/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client;

import io.cloudsoft.winrm4j.client.WinRm;
import io.cloudsoft.winrm4j.client.enumeration.EnumerateResponse;
import io.cloudsoft.winrm4j.client.enumeration.PullResponse;
import io.cloudsoft.winrm4j.client.wsman.Enumerate;
import io.cloudsoft.winrm4j.client.wsman.Filter;
import io.cloudsoft.winrm4j.client.wsman.Items;
import io.cloudsoft.winrm4j.client.wsman.Locale;
import io.cloudsoft.winrm4j.client.wsman.OptionSetType;
import io.cloudsoft.winrm4j.client.wsman.Pull;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EnumerateCommand
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger((String)EnumerateCommand.class.getName());
    static final String WSMAN_FAULT_CODE_OPERATION_TIMEOUT_EXPIRED = "2150858793";
    private final WinRm winrm;
    private final String resourceUri;
    private final String sessionId;
    private final long maxElements;
    private final Supplier<String> operationTimeout;
    private final Supplier<Locale> locale;
    private final Predicate<String> retryReceiveAfterOperationTimeout;
    private final DocumentBuilder documentBuilder;

    public EnumerateCommand(WinRm winrm, String resourceUri, long maxElements, Supplier<String> operationTimeout, Supplier<Locale> locale, Predicate<String> retryReceiveAfterOperationTimeout) {
        this.winrm = winrm;
        this.resourceUri = resourceUri;
        this.sessionId = "uuid:" + String.valueOf(UUID.randomUUID());
        this.maxElements = maxElements;
        this.operationTimeout = operationTimeout;
        this.locale = locale;
        this.retryReceiveAfterOperationTimeout = retryReceiveAfterOperationTimeout;
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Failed to create instance of DocumentBuilder");
        }
    }

    public List<Node> execute(String filter, String dialect) {
        EnumerateResponse enumerateResponse = this.enumerate(filter, dialect);
        ArrayList<Node> result = new ArrayList<Node>();
        this.collectAndIterateEnumeratedResults(result, new EnumerationPullState(this.resourceUri, this.maxElements, enumerateResponse.getEnumerationContext(), enumerateResponse.getItems(), enumerateResponse.getEndOfSequence() != null));
        return result;
    }

    private EnumerateResponse enumerate(String filter, String dialect) {
        while (true) {
            try {
                Enumerate enumerate = new Enumerate();
                enumerate.setFilter(new Filter());
                enumerate.getFilter().setValue(filter);
                enumerate.getFilter().setDialect(dialect);
                enumerate.setMaxElements(this.maxElements);
                return this.winrm.enumerate(enumerate, this.resourceUri, this.sessionId, 153600, this.operationTimeout.get(), this.locale.get(), new OptionSetType());
            }
            catch (SOAPFaultException soapFault) {
                this.assertFaultCode(soapFault, WSMAN_FAULT_CODE_OPERATION_TIMEOUT_EXPIRED, this.retryReceiveAfterOperationTimeout);
                continue;
            }
            break;
        }
    }

    private PullResponse pull(EnumerationPullState state) {
        while (true) {
            try {
                Pull pull = new Pull();
                pull.setEnumerationContext(state.getEnumerationContext());
                pull.setMaxElements(this.maxElements);
                return this.winrm.enumeratePull(pull, state.getResourceId(), this.sessionId, 153600, this.operationTimeout.get(), this.locale.get(), new OptionSetType());
            }
            catch (SOAPFaultException soapFault) {
                this.assertFaultCode(soapFault, WSMAN_FAULT_CODE_OPERATION_TIMEOUT_EXPIRED, this.retryReceiveAfterOperationTimeout);
                continue;
            }
            break;
        }
    }

    void collectAndIterateEnumeratedResults(List<Node> result, EnumerationPullState state) {
        List<Object> elements;
        Document doc = this.documentBuilder.newDocument();
        Element root = doc.createElement("results");
        doc.appendChild(root);
        Items items = state.getItems();
        if (items != null && (elements = items.getAny()) != null) {
            for (Object element : elements) {
                if (element instanceof Node) {
                    Node node = doc.importNode((Node)element, true);
                    root.appendChild(node);
                    result.add(node);
                    continue;
                }
                LOG.debug("{} unexpected element type {}", (Object)this, (Object)element.getClass().getCanonicalName());
            }
        }
        if (state.getEnumerationContext() != null && !state.isEndOfSequence()) {
            PullResponse next = this.pull(state);
            boolean endOfSequence = next.getEndOfSequence() != null;
            LOG.debug("{} endOfSequence = {}", (Object)this, (Object)endOfSequence);
            this.collectAndIterateEnumeratedResults(result, new EnumerationPullState(state.getResourceId(), state.getMaxElements(), next.getEnumerationContext(), next.getItems(), endOfSequence));
        }
    }

    void assertFaultCode(SOAPFaultException soapFault, String code, Predicate<String> retry) {
        try {
            NodeList faultDetails = soapFault.getFault().getDetail().getChildNodes();
            for (int i = 0; i < faultDetails.getLength(); ++i) {
                if (!faultDetails.item(i).getLocalName().equals("WSManFault")) continue;
                if (faultDetails.item(i).getAttributes().getNamedItem("Code").getNodeValue().equals(code) && retry.test(code)) {
                    LOG.trace("winrm client {} received error 500 response with code {}, response {}", new Object[]{this, code, soapFault});
                    return;
                }
                throw soapFault;
            }
            throw soapFault;
        }
        catch (NullPointerException e) {
            LOG.debug("Error reading Fault Code {}", (Object)soapFault.getFault());
            throw soapFault;
        }
    }

    @Override
    public void close() throws Exception {
    }

    static class EnumerationPullState {
        private final String resourceId;
        private final long maxElements;
        private final String enumerationContext;
        private final Items items;
        private final boolean endOfSequence;

        public EnumerationPullState(String resourceId, long maxElements, String enumerationContext, Items items, boolean endOfSequence) {
            this.resourceId = resourceId;
            this.maxElements = maxElements;
            this.enumerationContext = enumerationContext;
            this.items = items;
            this.endOfSequence = endOfSequence;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public long getMaxElements() {
            return this.maxElements;
        }

        public String getEnumerationContext() {
            return this.enumerationContext;
        }

        public Items getItems() {
            return this.items;
        }

        public boolean isEndOfSequence() {
            return this.endOfSequence;
        }
    }
}

