/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client;

import io.cloudsoft.winrm4j.client.WinRm;
import io.cloudsoft.winrm4j.client.WinRmClientBuilder;
import io.cloudsoft.winrm4j.client.retry.RetryDecision;
import io.cloudsoft.winrm4j.client.retry.RetryPolicy;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetryingProxyHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RetryingProxyHandler.class);
    private final WinRm winrm;
    private RetryPolicy failureRetryPolicy;

    public RetryingProxyHandler(WinRm winrm, RetryPolicy failureRetryPolicy) {
        this.winrm = winrm;
        this.failureRetryPolicy = failureRetryPolicy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("command")) {
            return method.invoke((Object)this.winrm, args);
        }
        return this.invokeWithRetry(method, args);
    }

    public Object invokeWithRetry(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        WebServiceException firstException = null;
        boolean tryAgain = true;
        int attempt = 0;
        while (true) {
            ++attempt;
            try {
                return method.invoke((Object)this.winrm, args);
            }
            catch (InvocationTargetException targetException) {
                RetryDecision retryDecision;
                Throwable e = targetException.getTargetException();
                RetryingProxyHandler.checkForRootErrorAuthorizationLoopAndPropagateAnnotated(e);
                if (e instanceof SOAPFaultException) {
                    throw (SOAPFaultException)e;
                }
                if (!(e instanceof WebServiceException)) {
                    throw new IllegalStateException("Failure when calling " + String.valueOf(method) + String.valueOf(args), e);
                }
                WebServiceException wsException = (WebServiceException)e;
                if (!(wsException.getCause() instanceof IOException)) {
                    throw new RuntimeException("Exception occurred while making winrm call", (Throwable)wsException);
                }
                if (firstException == null) {
                    firstException = wsException;
                }
                if ((retryDecision = this.failureRetryPolicy.onWebServiceException(wsException, attempt)).shouldRetry()) {
                    LOG.debug("On attempt " + attempt + ", ignoring exception and retrying (" + String.valueOf(retryDecision.reason()) + ")", (Throwable)wsException);
                    try {
                        Thread.sleep(retryDecision.pauseTimeMillis());
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Exception occured while making winrm call", targetException);
                    }
                } else {
                    tryAgain = false;
                }
                if (tryAgain) continue;
                LOG.debug("failed task \"" + method.getName() + "\" after " + attempt + " attempt(s), rethrowing first exception");
                throw new RuntimeException("failed task \"" + method.getName() + "\" after " + attempt + " attempt(s)", (Throwable)firstException);
            }
            break;
        }
    }

    public static void checkForRootErrorAuthorizationLoopAndPropagateAnnotated(Throwable e0) {
        for (Throwable e = e0; e != null; e = e.getCause()) {
            String es = e.toString();
            if (es.contains("ncompatible authentication schemes")) {
                if (e0 instanceof RuntimeException) {
                    throw (RuntimeException)e0;
                }
                throw new RuntimeException(e0);
            }
            if (e.toString().contains("Authorization loop detected on Conduit")) {
                throw new IllegalStateException("Invalid credentials or incompatible authentication schemes", e0);
            }
            if (e.getCause() != null && e.getCause() != e) continue;
            return;
        }
    }

    @Deprecated
    public void setRetriesForConnectionFailures(int retries) {
        LOG.warn("method RetryingProxyHandler#setRetriesForConnectionFailures has been deprecated, please use instead WinRmClientBuilder#failureRetryPolicy");
        this.failureRetryPolicy = WinRmClientBuilder.simpleCounterRetryPolicy(retries);
    }
}

