/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client.encryption;

import io.cloudsoft.winrm4j.client.PayloadEncryptionMode;
import io.cloudsoft.winrm4j.client.encryption.AsyncHttpEncryptionAwareConduitFactory;
import io.cloudsoft.winrm4j.client.encryption.NtlmEncryptionUtils;
import io.cloudsoft.winrm4j.client.encryption.SignAndEncryptOutInterceptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import org.apache.cxf.Bus;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.Address;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduit;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduitFactory;
import org.apache.cxf.transport.http.asyncclient.CXFHttpRequest;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.auth.Credentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.entity.BasicHttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpEncryptionAwareConduit
extends AsyncHTTPConduit {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncHttpEncryptionAwareConduit.class);
    public static final byte[] PRE_AUTH_BOGUS_PAYLOAD = "AWAITING_ENCRYPTION_KEYS".getBytes();
    private final PayloadEncryptionMode payloadEncryptionMode;
    private final Collection<String> targetAuthSchemes;

    static SignAndEncryptOutInterceptor.ContentWithType getAppropriate(Message msg) {
        SignAndEncryptOutInterceptor.EncryptAndSignOutputStream encryptingStream = (SignAndEncryptOutInterceptor.EncryptAndSignOutputStream)((Object)msg.getContent(SignAndEncryptOutInterceptor.EncryptAndSignOutputStream.class));
        if (encryptingStream == null) {
            throw new IllegalStateException("No SignAndEncryptOutInterceptor applied to message");
        }
        return encryptingStream.getAppropriate();
    }

    public AsyncHttpEncryptionAwareConduit(PayloadEncryptionMode payloadEncryptionMode, Bus b, EndpointInfo ei, EndpointReferenceType t, AsyncHttpEncryptionAwareConduitFactory factory) throws IOException {
        super(b, ei, t, (AsyncHTTPConduitFactory)factory);
        this.payloadEncryptionMode = factory.payloadEncryptionMode;
        this.targetAuthSchemes = factory.targetAuthSchemes;
    }

    protected OutputStream createOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) throws IOException {
        NtlmEncryptionUtils encryptor = NtlmEncryptionUtils.of((Credentials)message.get(Credentials.class), this.payloadEncryptionMode);
        if (encryptor == null) {
            return super.createOutputStream(message, needToCacheRequest, isChunking, chunkThreshold);
        }
        if (Boolean.TRUE.equals(message.get((Object)"use.async.http.conduit"))) {
            if (!needToCacheRequest) {
                LOG.warn("WinRM conduit assuming need to cache request, even though not requested");
            }
            if (isChunking) {
                LOG.warn("WinRM conduit preventing chunking, even though requested");
            }
            CXFHttpRequest requestEntity = (CXFHttpRequest)message.get(CXFHttpRequest.class);
            AsyncWrappedEncryptionAwareOutputStream out = new AsyncWrappedEncryptionAwareOutputStream(message, true, false, chunkThreshold, this.getConduitName(), requestEntity.getURI());
            requestEntity.setOutputStream((AsyncHTTPConduit.AsyncWrappedOutputStream)out);
            return out;
        }
        throw new IllegalStateException("Encryption only available with ASYNC at present");
    }

    protected void setupConnection(final Message message, Address address, HTTPClientPolicy csPolicy) throws IOException {
        super.setupConnection(message, address, csPolicy);
        final CXFHttpRequest requestEntity = (CXFHttpRequest)message.get(CXFHttpRequest.class);
        EncryptionAwareHttpEntity entity = new EncryptionAwareHttpEntity(){

            public boolean isRepeatable() {
                return requestEntity.getOutputStream().retransmitable();
            }

            @Override
            protected SignAndEncryptOutInterceptor.ContentWithType getAppropriate() {
                return AsyncHttpEncryptionAwareConduit.getAppropriate(message);
            }
        };
        entity.setChunked(true);
        entity.setContentType((String)message.get((Object)"Content-Type"));
        requestEntity.setEntity((HttpEntity)entity);
        requestEntity.setConfig(RequestConfig.copy((RequestConfig)requestEntity.getConfig()).setTargetPreferredAuthSchemes(this.targetAuthSchemes).build());
    }

    public class AsyncWrappedEncryptionAwareOutputStream
    extends AsyncHTTPConduit.AsyncWrappedOutputStream {
        public AsyncWrappedEncryptionAwareOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold, String conduitName, URI uri) {
            super((AsyncHTTPConduit)AsyncHttpEncryptionAwareConduit.this, message, needToCacheRequest, isChunking, chunkThreshold, conduitName, uri);
        }

        protected void setupWrappedStream() throws IOException {
            LOG.trace("Setting up wrapped stream with {}", (Object)this.cachedStream);
            super.setupWrappedStream();
            if (this.cachedStream.getFlowThroughStream() instanceof EncryptionAwareCacheAndWriteOutputStream) {
                LOG.warn("Duplicate calls to setupWrappedStream; ignoring");
            } else {
                this.cachedStream = new EncryptionAwareCacheAndWriteOutputStream(this.cachedStream.getFlowThroughStream());
                this.wrappedStream = this.cachedStream;
            }
        }

        private SignAndEncryptOutInterceptor.ContentWithType getAppropriate() {
            return AsyncHttpEncryptionAwareConduit.getAppropriate(this.outMessage);
        }

        private class EncryptionAwareCacheAndWriteOutputStream
        extends CacheAndWriteOutputStream {
            public EncryptionAwareCacheAndWriteOutputStream(OutputStream outbufFlowThroughStream) {
                super(outbufFlowThroughStream);
            }

            public byte[] getBytes() throws IOException {
                return AsyncWrappedEncryptionAwareOutputStream.this.getAppropriate().payload;
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(this.getBytes());
            }
        }
    }

    public static abstract class EncryptionAwareHttpEntity
    extends BasicHttpEntity {
        public void refreshHeaders(HttpEntityEnclosingRequest request) {
            if (request.getEntity() != this) {
                LOG.warn("Request entity mismatch " + String.valueOf(request) + " sought " + String.valueOf(request.getEntity()) + " but we are " + String.valueOf((Object)this));
            }
            SignAndEncryptOutInterceptor.ContentWithType appropriate = this.getAppropriate();
            this.setContentLength(appropriate.payload.length);
            request.setHeader("Content-Length", "" + appropriate.payload.length);
            request.setHeader("Content-Type", appropriate.contentType);
        }

        protected abstract SignAndEncryptOutInterceptor.ContentWithType getAppropriate();
    }
}

