/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client.encryption;

import io.cloudsoft.winrm4j.client.PayloadEncryptionMode;
import io.cloudsoft.winrm4j.client.encryption.AsyncHttpEncryptionAwareConduit;
import io.cloudsoft.winrm4j.client.encryption.NtlmEncryptionUtils;
import io.cloudsoft.winrm4j.client.ntlm.NTCredentialsWithEncryption;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.http.auth.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignAndEncryptOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(SignAndEncryptOutInterceptor.class);
    public static final String APPLIED = SignAndEncryptOutInterceptor.class.getSimpleName() + ".APPLIED";
    private final PayloadEncryptionMode payloadEncryptionMode;

    public SignAndEncryptOutInterceptor(PayloadEncryptionMode payloadEncryptionMode) {
        super("pre-stream");
        this.addBefore(StaxOutInterceptor.class.getName());
        this.payloadEncryptionMode = payloadEncryptionMode;
    }

    public void handleMessage(Message message) {
        boolean hasApplied = message.containsKey((Object)APPLIED);
        if (!hasApplied) {
            message.put((Object)APPLIED, (Object)Boolean.TRUE);
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            EncryptAndSignOutputStream newOut = new EncryptAndSignOutputStream(message, os);
            message.setContent(OutputStream.class, (Object)newOut);
            message.setContent(EncryptAndSignOutputStream.class, (Object)newOut);
        }
    }

    class EncryptAndSignOutputStream
    extends CachedOutputStream {
        final CachedOutputStream unencrypted;
        ContentWithType unencryptedResult = null;
        ContentWithType encrypted = null;
        final Message message;
        OutputStream wrapped;
        NTCredentialsWithEncryption credentials;

        public EncryptAndSignOutputStream(Message message, OutputStream os) {
            this.message = message;
            this.wrapped = os;
            this.unencrypted = new CachedOutputStream();
            Object creds = message.get((Object)Credentials.class.getName());
            if (creds instanceof NTCredentialsWithEncryption) {
                this.credentials = (NTCredentialsWithEncryption)((Object)creds);
            }
        }

        public void resetOut(OutputStream out, boolean copyOldContent) throws IOException {
            super.resetOut(out, copyOldContent);
        }

        public void close() throws IOException {
            LOG.trace("Closing stream {}", (Object)this.wrapped);
            super.close();
            this.unencrypted.write(this.getBytes());
            this.currentStream = new NullOutputStream();
            if (this.wrapped != null) {
                try {
                    this.processAndShip(this.wrapped);
                }
                finally {
                    this.wrapped.close();
                }
            } else {
                LOG.warn("No stream for writing encrypted message to");
            }
        }

        protected synchronized ContentWithType getEncrypted() {
            try {
                if (this.encrypted == null) {
                    byte[] bytesEncryptedAndSigned = new NtlmEncryptionUtils(this.credentials, SignAndEncryptOutInterceptor.this.payloadEncryptionMode).encryptAndSign(this.message, this.unencrypted.getBytes());
                    this.encrypted = ContentWithType.of(this.message, bytesEncryptedAndSigned);
                }
                return this.encrypted;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        protected byte[] getUnencrypted() {
            try {
                return this.unencrypted.getBytes();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public synchronized ContentWithType getAppropriate() {
            return this.getAppropriate(false);
        }

        public synchronized ContentWithType getAppropriate(boolean isFirstInvocation) {
            if (this.unencryptedResult == null) {
                this.unencryptedResult = ContentWithType.of(this.message, null);
            }
            if (!SignAndEncryptOutInterceptor.this.payloadEncryptionMode.isPermitted() || this.credentials == null || !this.credentials.isAuthenticated()) {
                if (this.encrypted != null) {
                    this.encrypted = null;
                    LOG.debug("Clearing previously encrypted message becasue credentials no longer authenticated");
                }
                if (SignAndEncryptOutInterceptor.this.payloadEncryptionMode.isRequired() && this.credentials == null) {
                    throw new IllegalStateException("Encryption required but unavailable");
                }
                if (this.credentials != null && !this.credentials.isAuthenticated()) {
                    return this.unencryptedResult.with(AsyncHttpEncryptionAwareConduit.PRE_AUTH_BOGUS_PAYLOAD);
                }
                return this.unencryptedResult.with(this.getUnencrypted());
            }
            return this.getEncrypted();
        }

        protected void processAndShip(OutputStream output) throws IOException {
            output.write(this.getAppropriate((boolean)true).payload);
            output.close();
        }
    }

    public static class ContentWithType {
        public String contentType;
        public String encoding;
        public byte[] payload;

        static ContentWithType of(Message message, byte[] payload) {
            return ContentWithType.of((String)message.get((Object)"Content-Type"), (String)message.get((Object)Message.ENCODING), payload);
        }

        static ContentWithType of(String contentType, String encoding, byte[] payload) {
            ContentWithType result = new ContentWithType();
            result.contentType = contentType;
            result.encoding = encoding;
            result.payload = payload;
            return result;
        }

        public ContentWithType with(byte[] payload) {
            return ContentWithType.of(this.contentType, this.encoding, payload);
        }
    }
}

