/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.hippo4j.common.notify.platform;

/**
 * We chat alarm constants.
 */
public class WeChatAlarmConstants {

    /**
     * 企微机器人 Url
     */
    public static final String WE_CHAT_SERVER_URL = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=";

    /**
     * Trace 信息
     */
    public static final String WE_CHAT_ALARM_TIMOUT_TRACE_REPLACE_TXT = "> 链路信息：%s \n";

    /**
     * 替换任务超时模板
     */
    public static final String WE_CHAT_ALARM_TIMOUT_REPLACE_TXT =
            "> 任务执行时间：%s / ms \n" +
                    "> 超时时间：%s / ms \n" +
                    WE_CHAT_ALARM_TIMOUT_TRACE_REPLACE_TXT;

    /**
     * 线程池报警通知文本
     */
    public static final String WE_CHAT_ALARM_TXT =
            "### <font color='#FF0000'>[警报] </font>%s - 动态线程池运行告警（%s） \n" +
                    "> 线程池ID：<font color=\"warning\">%s</font> \n" +
                    "> 应用名称：<font color=\"warning\">%s</font> \n" +
                    "> 应用实例：%s \n" +
                    "> 核心线程数：%s \n" +
                    "> 最大线程数：%s \n" +
                    "> 当前线程数：%s \n" +
                    "> 活跃线程数：%s \n" +
                    "> 同存最大线程数：%s \n" +
                    "> 线程池任务总量：%s \n" +
                    "> 队列类型：%s \n" +
                    "> 队列容量：%s \n" +
                    "> 队列元素个数：%s \n" +
                    "> 队列剩余个数：%s \n" +
                    "> 拒绝策略：%s \n" +
                    "> 拒绝策略执行次数：<font color='#FF0000'>%s</font> \n" +
                    WE_CHAT_ALARM_TIMOUT_REPLACE_TXT +
                    "> OWNER：<@%s> \n" +
                    "> 提示：%d 分钟内此线程池不会重复告警（可配置） \n\n" +
                    "**播报时间：%s**";

    /**
     * 线程池参数变更通知文本
     */
    public static final String WE_CHAT_NOTICE_TXT =
            "### <font color=\"info\">[通知] </font>%s - 动态线程池参数变更 \n" +
                    "> 线程池ID：<font color=\"warning\">%s</font> \n" +
                    "> 应用名称：<font color=\"warning\">%s</font> \n" +
                    "> 应用实例：%s \n" +
                    "> 核心线程数：%s \n" +
                    "> 最大线程数：%s \n" +
                    "> 核心线程超时：%s \n" +
                    "> 线程存活时间：%s \n" +
                    "> 执行超时时间：%s \n" +
                    "> 队列类型：%s \n" +
                    "> 队列容量：%s \n" +
                    "> AGO 拒绝策略：%s \n" +
                    "> NOW 拒绝策略：%s \n" +
                    "> OWNER：<@%s> \n" +
                    "> 提示：动态线程池配置变更实时通知（无限制） \n\n" +
                    "**播报时间：%s**";
}
