/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceInfo {
    private static final Logger log = LoggerFactory.getLogger(InstanceInfo.class);
    private static final String UNKNOWN = "unknown";
    private String appName = "unknown";
    private String hostName;
    private String groupKey;
    private String port;
    private String instanceId;
    private String ipApplicationName;
    private String clientBasePath;
    private String callBackUrl;
    private String identify;
    private String active;
    private volatile String vipAddress;
    private volatile String secureVipAddress;
    private volatile ActionType actionType;
    private volatile boolean isInstanceInfoDirty = false;
    private volatile Long lastUpdatedTimestamp;
    private volatile Long lastDirtyTimestamp;
    private volatile InstanceStatus status = InstanceStatus.UP;
    private volatile InstanceStatus overriddenStatus = InstanceStatus.UNKNOWN;

    public InstanceInfo() {
        this.lastDirtyTimestamp = this.lastUpdatedTimestamp = Long.valueOf(System.currentTimeMillis());
    }

    public void setLastUpdatedTimestamp() {
        this.lastUpdatedTimestamp = System.currentTimeMillis();
    }

    public Long getLastDirtyTimestamp() {
        return this.lastDirtyTimestamp;
    }

    public synchronized void setOverriddenStatus(InstanceStatus status) {
        if (this.overriddenStatus != status) {
            this.overriddenStatus = status;
        }
    }

    public InstanceStatus getStatus() {
        return this.status;
    }

    public synchronized void setIsDirty() {
        this.isInstanceInfoDirty = true;
        this.lastDirtyTimestamp = System.currentTimeMillis();
    }

    public synchronized long setIsDirtyWithTime() {
        this.setIsDirty();
        return this.lastDirtyTimestamp;
    }

    public synchronized void unsetIsDirty(long unsetDirtyTimestamp) {
        if (this.lastDirtyTimestamp <= unsetDirtyTimestamp) {
            this.isInstanceInfoDirty = false;
        }
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public String getPort() {
        return this.port;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getIpApplicationName() {
        return this.ipApplicationName;
    }

    public String getClientBasePath() {
        return this.clientBasePath;
    }

    public String getCallBackUrl() {
        return this.callBackUrl;
    }

    public String getIdentify() {
        return this.identify;
    }

    public String getActive() {
        return this.active;
    }

    public String getVipAddress() {
        return this.vipAddress;
    }

    public String getSecureVipAddress() {
        return this.secureVipAddress;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public boolean isInstanceInfoDirty() {
        return this.isInstanceInfoDirty;
    }

    public Long getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public InstanceStatus getOverriddenStatus() {
        return this.overriddenStatus;
    }

    public InstanceInfo setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public InstanceInfo setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public InstanceInfo setGroupKey(String groupKey) {
        this.groupKey = groupKey;
        return this;
    }

    public InstanceInfo setPort(String port) {
        this.port = port;
        return this;
    }

    public InstanceInfo setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public InstanceInfo setIpApplicationName(String ipApplicationName) {
        this.ipApplicationName = ipApplicationName;
        return this;
    }

    public InstanceInfo setClientBasePath(String clientBasePath) {
        this.clientBasePath = clientBasePath;
        return this;
    }

    public InstanceInfo setCallBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
        return this;
    }

    public InstanceInfo setIdentify(String identify) {
        this.identify = identify;
        return this;
    }

    public InstanceInfo setActive(String active) {
        this.active = active;
        return this;
    }

    public InstanceInfo setVipAddress(String vipAddress) {
        this.vipAddress = vipAddress;
        return this;
    }

    public InstanceInfo setSecureVipAddress(String secureVipAddress) {
        this.secureVipAddress = secureVipAddress;
        return this;
    }

    public InstanceInfo setInstanceInfoDirty(boolean isInstanceInfoDirty) {
        this.isInstanceInfoDirty = isInstanceInfoDirty;
        return this;
    }

    public InstanceInfo setLastUpdatedTimestamp(Long lastUpdatedTimestamp) {
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        return this;
    }

    public InstanceInfo setLastDirtyTimestamp(Long lastDirtyTimestamp) {
        this.lastDirtyTimestamp = lastDirtyTimestamp;
        return this;
    }

    public InstanceInfo setStatus(InstanceStatus status) {
        this.status = status;
        return this;
    }

    public static class InstanceRenew {
        private String appName;
        private String instanceId;
        private String lastDirtyTimestamp;
        private String status;

        public String getAppName() {
            return this.appName;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getLastDirtyTimestamp() {
            return this.lastDirtyTimestamp;
        }

        public String getStatus() {
            return this.status;
        }

        public InstanceRenew setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public InstanceRenew setInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public InstanceRenew setLastDirtyTimestamp(String lastDirtyTimestamp) {
            this.lastDirtyTimestamp = lastDirtyTimestamp;
            return this;
        }

        public InstanceRenew setStatus(String status) {
            this.status = status;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceRenew)) {
                return false;
            }
            InstanceRenew other = (InstanceRenew)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$appName = this.getAppName();
            String other$appName = other.getAppName();
            if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
                return false;
            }
            String this$instanceId = this.getInstanceId();
            String other$instanceId = other.getInstanceId();
            if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
                return false;
            }
            String this$lastDirtyTimestamp = this.getLastDirtyTimestamp();
            String other$lastDirtyTimestamp = other.getLastDirtyTimestamp();
            if (this$lastDirtyTimestamp == null ? other$lastDirtyTimestamp != null : !this$lastDirtyTimestamp.equals(other$lastDirtyTimestamp)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InstanceRenew;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appName = this.getAppName();
            result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
            String $instanceId = this.getInstanceId();
            result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
            String $lastDirtyTimestamp = this.getLastDirtyTimestamp();
            result = result * 59 + ($lastDirtyTimestamp == null ? 43 : $lastDirtyTimestamp.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public String toString() {
            return "InstanceInfo.InstanceRenew(appName=" + this.getAppName() + ", instanceId=" + this.getInstanceId() + ", lastDirtyTimestamp=" + this.getLastDirtyTimestamp() + ", status=" + this.getStatus() + ")";
        }
    }

    public static enum ActionType {
        ADDED,
        MODIFIED,
        DELETED;

    }

    public static enum InstanceStatus {
        UP,
        DOWN,
        STARTING,
        OUT_OF_SERVICE,
        UNKNOWN;


        public static InstanceStatus toEnum(String s) {
            if (s != null) {
                try {
                    return InstanceStatus.valueOf(s.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    log.debug("illegal argument supplied to InstanceStatus.valueOf: {}, defaulting to {}", (Object)s, (Object)UNKNOWN);
                }
            }
            return UNKNOWN;
        }
    }
}

