/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.notify;

import cn.hippo4j.common.notify.AlarmControlDTO;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class AlarmControlHandler {
    private final Map<String, ReentrantLock> threadPoolLock = Maps.newHashMap();
    private final Map<String, Cache<String, String>> threadPoolAlarmCache = Maps.newConcurrentMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSendAlarm(AlarmControlDTO alarmControl) {
        String threadPoolKey = alarmControl.buildPk();
        Cache<String, String> cache = this.threadPoolAlarmCache.get(threadPoolKey);
        if (cache == null) {
            return false;
        }
        String pkId = (String)cache.getIfPresent((Object)alarmControl.getTypeEnum().name());
        if (StrUtil.isBlank((CharSequence)pkId)) {
            ReentrantLock lock = this.threadPoolLock.get(threadPoolKey);
            lock.lock();
            try {
                pkId = (String)cache.getIfPresent((Object)alarmControl.getTypeEnum().name());
                if (StrUtil.isBlank((CharSequence)pkId)) {
                    cache.put((Object)alarmControl.getTypeEnum().name(), (Object)IdUtil.simpleUUID());
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    public void initCacheAndLock(String threadPoolId, String platform, Integer interval) {
        String threadPoolKey = StrUtil.builder((CharSequence[])new CharSequence[]{threadPoolId, "+", platform}).toString();
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite((long)interval.intValue(), TimeUnit.MINUTES).build();
        this.threadPoolAlarmCache.put(threadPoolKey, (Cache<String, String>)cache);
        ReentrantLock reentrantLock = new ReentrantLock();
        this.threadPoolLock.put(threadPoolKey, reentrantLock);
    }
}

