/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.notify;

import cn.hippo4j.common.api.NotifyConfigBuilder;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.notify.AlarmControlDTO;
import cn.hippo4j.common.notify.AlarmControlHandler;
import cn.hippo4j.common.notify.HippoSendMessageService;
import cn.hippo4j.common.notify.NotifyConfigDTO;
import cn.hippo4j.common.notify.NotifyTypeEnum;
import cn.hippo4j.common.notify.SendMessageHandler;
import cn.hippo4j.common.notify.request.AlarmNotifyRequest;
import cn.hippo4j.common.notify.request.ChangeParameterNotifyRequest;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;

public class HippoBaseSendMessageService
implements HippoSendMessageService,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(HippoBaseSendMessageService.class);
    private final NotifyConfigBuilder notifyConfigBuilder;
    private final AlarmControlHandler alarmControlHandler;
    private final Map<String, List<NotifyConfigDTO>> notifyConfigs = Maps.newHashMap();
    private final Map<String, SendMessageHandler> sendMessageHandlers = Maps.newHashMap();

    @Override
    public void sendAlarmMessage(NotifyTypeEnum typeEnum, AlarmNotifyRequest alarmNotifyRequest) {
        String threadPoolId = alarmNotifyRequest.getThreadPoolId();
        String buildKey = StrUtil.builder((CharSequence[])new CharSequence[]{threadPoolId, "+", "ALARM"}).toString();
        List<NotifyConfigDTO> notifyList = this.notifyConfigs.get(buildKey);
        if (CollUtil.isEmpty(notifyList)) {
            return;
        }
        notifyList.forEach(each -> {
            try {
                SendMessageHandler messageHandler = this.sendMessageHandlers.get(each.getPlatform());
                if (messageHandler == null) {
                    log.warn("Please configure alarm notification on the server. key :: [{}]", (Object)threadPoolId);
                    return;
                }
                if (this.isSendAlarm(each.getTpId(), each.getPlatform(), typeEnum)) {
                    alarmNotifyRequest.setNotifyTypeEnum(typeEnum);
                    messageHandler.sendAlarmMessage((NotifyConfigDTO)each, alarmNotifyRequest);
                }
            }
            catch (Exception ex) {
                log.warn("Failed to send thread pool alarm notification. key :: [{}]", (Object)threadPoolId, (Object)ex);
            }
        });
    }

    @Override
    public void sendChangeMessage(ChangeParameterNotifyRequest changeParameterNotifyRequest) {
        String threadPoolId = changeParameterNotifyRequest.getThreadPoolId();
        String buildKey = StrUtil.builder((CharSequence[])new CharSequence[]{threadPoolId, "+", "CONFIG"}).toString();
        List<NotifyConfigDTO> notifyList = this.notifyConfigs.get(buildKey);
        if (CollUtil.isEmpty(notifyList)) {
            log.warn("Please configure alarm notification on the server. key :: [{}]", (Object)threadPoolId);
            return;
        }
        notifyList.forEach(each -> {
            try {
                SendMessageHandler messageHandler = this.sendMessageHandlers.get(each.getPlatform());
                if (messageHandler == null) {
                    log.warn("Please configure alarm notification on the server. key :: [{}]", (Object)threadPoolId);
                    return;
                }
                messageHandler.sendChangeMessage((NotifyConfigDTO)each, changeParameterNotifyRequest);
            }
            catch (Exception ex) {
                log.warn("Failed to send thread pool change notification. key :: [{}]", (Object)threadPoolId, (Object)ex);
            }
        });
    }

    private boolean isSendAlarm(String threadPoolId, String platform, NotifyTypeEnum typeEnum) {
        AlarmControlDTO alarmControl = AlarmControlDTO.builder().threadPool(threadPoolId).platform(platform).typeEnum(typeEnum).build();
        return this.alarmControlHandler.isSendAlarm(alarmControl);
    }

    public void run(String ... args) throws Exception {
        Map<String, SendMessageHandler> sendMessageHandlerMap = ApplicationContextHolder.getBeansOfType(SendMessageHandler.class);
        sendMessageHandlerMap.values().forEach(each -> this.sendMessageHandlers.put(each.getType(), (SendMessageHandler)each));
        Map<String, List<NotifyConfigDTO>> buildNotify = this.notifyConfigBuilder.buildNotify();
        this.notifyConfigs.putAll(buildNotify);
    }

    public synchronized void putPlatform(Map<String, List<NotifyConfigDTO>> notifyConfigs) {
        this.notifyConfigs.putAll(notifyConfigs);
    }

    public HippoBaseSendMessageService(NotifyConfigBuilder notifyConfigBuilder, AlarmControlHandler alarmControlHandler) {
        this.notifyConfigBuilder = notifyConfigBuilder;
        this.alarmControlHandler = alarmControlHandler;
    }
}

