/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.notify.platform;

import cn.hippo4j.common.notify.NotifyConfigDTO;
import cn.hippo4j.common.notify.NotifyPlatformEnum;
import cn.hippo4j.common.notify.NotifyTypeEnum;
import cn.hippo4j.common.notify.SendMessageHandler;
import cn.hippo4j.common.notify.request.AlarmNotifyRequest;
import cn.hippo4j.common.notify.request.ChangeParameterNotifyRequest;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiRobotSendRequest;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingSendMessageHandler
implements SendMessageHandler<AlarmNotifyRequest, ChangeParameterNotifyRequest> {
    private static final Logger log = LoggerFactory.getLogger(DingSendMessageHandler.class);

    @Override
    public String getType() {
        return NotifyPlatformEnum.DING.name();
    }

    @Override
    public void sendAlarmMessage(NotifyConfigDTO notifyConfig, AlarmNotifyRequest alarmNotifyRequest) {
        String dingAlarmTxt;
        Object[] receives = notifyConfig.getReceives().split(",");
        String afterReceives = Joiner.on((String)", @").join(receives);
        if (Objects.equals((Object)alarmNotifyRequest.getNotifyTypeEnum(), (Object)NotifyTypeEnum.TIMEOUT)) {
            String dingAlarmTimoutReplaceTxt;
            String executeTimeoutTrace = alarmNotifyRequest.getExecuteTimeoutTrace();
            if (StringUtil.isNotBlank(executeTimeoutTrace)) {
                String dingAlarmTimoutTraceReplaceTxt = String.format("<font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n", executeTimeoutTrace);
                dingAlarmTimoutReplaceTxt = StrUtil.replace((CharSequence)"<font color=#708090 size=2>\u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%d / ms </font> \n\n<font color=#708090 size=2>\u8d85\u65f6\u65f6\u95f4\uff1a%d / ms</font> \n\n<font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n --- \n\n  ", (CharSequence)"<font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n", (CharSequence)dingAlarmTimoutTraceReplaceTxt);
            } else {
                dingAlarmTimoutReplaceTxt = StrUtil.replace((CharSequence)"<font color=#708090 size=2>\u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%d / ms </font> \n\n<font color=#708090 size=2>\u8d85\u65f6\u65f6\u95f4\uff1a%d / ms</font> \n\n<font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n --- \n\n  ", (CharSequence)"<font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n", (CharSequence)"");
            }
            dingAlarmTimoutReplaceTxt = String.format(dingAlarmTimoutReplaceTxt, alarmNotifyRequest.getExecuteTime(), alarmNotifyRequest.getExecuteTimeOut());
            dingAlarmTxt = StrUtil.replace((CharSequence)"**<font color=#FF0000>[\u8b66\u62a5] </font>%s - \u52a8\u6001\u7ebf\u7a0b\u6c60\u8fd0\u884c\u544a\u8b66\uff08%s\uff09** \n\n --- \n\n <font color=#708090 size=2>\u7ebf\u7a0b\u6c60ID\uff1a%s</font> \n\n <font color=#708090 size=2>\u5e94\u7528\u540d\u79f0\uff1a%s</font> \n\n <font color=#778899 size=2>\u5e94\u7528\u5b9e\u4f8b\uff1a%s</font> \n\n <font color=#778899 size=2>\u5b9e\u4f8b\u6807\u8bc6\uff1a%s</font> \n\n  --- \n\n  <font color=#708090 size=2>\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u5f53\u524d\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u6d3b\u8dc3\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u540c\u5b58\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u7ebf\u7a0b\u6c60\u4efb\u52a1\u603b\u91cf\uff1a%d</font> \n\n  --- \n\n  <font color=#708090 size=2>\u961f\u5217\u7c7b\u578b\uff1a%s</font> \n\n <font color=#708090 size=2>\u961f\u5217\u5bb9\u91cf\uff1a%d</font> \n\n <font color=#708090 size=2>\u961f\u5217\u5143\u7d20\u4e2a\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u961f\u5217\u5269\u4f59\u4e2a\u6570\uff1a%d</font> \n\n  --- \n\n  <font color=#708090 size=2>\u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%d / ms </font> \n\n<font color=#708090 size=2>\u8d85\u65f6\u65f6\u95f4\uff1a%d / ms</font> \n\n<font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n --- \n\n  <font color=#708090 size=2>\u62d2\u7edd\u7b56\u7565\uff1a%s</font> \n\n<font color=#708090 size=2>\u62d2\u7edd\u7b56\u7565\u6267\u884c\u6b21\u6570\uff1a</font><font color=#FF0000 size=2>%d</font> \n\n <font color=#708090 size=2>OWNER\uff1a@%s</font> \n\n<font color=#708090 size=2>\u63d0\u793a\uff1a%d \u5206\u949f\u5185\u6b64\u7ebf\u7a0b\u6c60\u4e0d\u4f1a\u91cd\u590d\u544a\u8b66\uff08\u53ef\u914d\u7f6e\uff09</font> \n\n --- \n\n  **\u64ad\u62a5\u65f6\u95f4\uff1a%s**", (CharSequence)"<font color=#708090 size=2>\u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%d / ms </font> \n\n<font color=#708090 size=2>\u8d85\u65f6\u65f6\u95f4\uff1a%d / ms</font> \n\n<font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n --- \n\n  ", (CharSequence)dingAlarmTimoutReplaceTxt);
        } else {
            dingAlarmTxt = StrUtil.replace((CharSequence)"**<font color=#FF0000>[\u8b66\u62a5] </font>%s - \u52a8\u6001\u7ebf\u7a0b\u6c60\u8fd0\u884c\u544a\u8b66\uff08%s\uff09** \n\n --- \n\n <font color=#708090 size=2>\u7ebf\u7a0b\u6c60ID\uff1a%s</font> \n\n <font color=#708090 size=2>\u5e94\u7528\u540d\u79f0\uff1a%s</font> \n\n <font color=#778899 size=2>\u5e94\u7528\u5b9e\u4f8b\uff1a%s</font> \n\n <font color=#778899 size=2>\u5b9e\u4f8b\u6807\u8bc6\uff1a%s</font> \n\n  --- \n\n  <font color=#708090 size=2>\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u5f53\u524d\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u6d3b\u8dc3\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u540c\u5b58\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u7ebf\u7a0b\u6c60\u4efb\u52a1\u603b\u91cf\uff1a%d</font> \n\n  --- \n\n  <font color=#708090 size=2>\u961f\u5217\u7c7b\u578b\uff1a%s</font> \n\n <font color=#708090 size=2>\u961f\u5217\u5bb9\u91cf\uff1a%d</font> \n\n <font color=#708090 size=2>\u961f\u5217\u5143\u7d20\u4e2a\u6570\uff1a%d</font> \n\n <font color=#708090 size=2>\u961f\u5217\u5269\u4f59\u4e2a\u6570\uff1a%d</font> \n\n  --- \n\n  <font color=#708090 size=2>\u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%d / ms </font> \n\n<font color=#708090 size=2>\u8d85\u65f6\u65f6\u95f4\uff1a%d / ms</font> \n\n<font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n --- \n\n  <font color=#708090 size=2>\u62d2\u7edd\u7b56\u7565\uff1a%s</font> \n\n<font color=#708090 size=2>\u62d2\u7edd\u7b56\u7565\u6267\u884c\u6b21\u6570\uff1a</font><font color=#FF0000 size=2>%d</font> \n\n <font color=#708090 size=2>OWNER\uff1a@%s</font> \n\n<font color=#708090 size=2>\u63d0\u793a\uff1a%d \u5206\u949f\u5185\u6b64\u7ebf\u7a0b\u6c60\u4e0d\u4f1a\u91cd\u590d\u544a\u8b66\uff08\u53ef\u914d\u7f6e\uff09</font> \n\n --- \n\n  **\u64ad\u62a5\u65f6\u95f4\uff1a%s**", (CharSequence)"<font color=#708090 size=2>\u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%d / ms </font> \n\n<font color=#708090 size=2>\u8d85\u65f6\u65f6\u95f4\uff1a%d / ms</font> \n\n<font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n --- \n\n  ", (CharSequence)"");
        }
        String[] strings = alarmNotifyRequest.getIdentify().split("_");
        String text = String.format(dingAlarmTxt, new Object[]{alarmNotifyRequest.getActive(), alarmNotifyRequest.getNotifyTypeEnum(), alarmNotifyRequest.getThreadPoolId(), alarmNotifyRequest.getAppName(), strings[0], strings[1], alarmNotifyRequest.getCorePoolSize(), alarmNotifyRequest.getMaximumPoolSize(), alarmNotifyRequest.getPoolSize(), alarmNotifyRequest.getActiveCount(), alarmNotifyRequest.getLargestPoolSize(), alarmNotifyRequest.getCompletedTaskCount(), alarmNotifyRequest.getQueueName(), alarmNotifyRequest.getCapacity(), alarmNotifyRequest.getQueueSize(), alarmNotifyRequest.getRemainingCapacity(), alarmNotifyRequest.getRejectedExecutionHandlerName(), alarmNotifyRequest.getRejectCountNum(), afterReceives, notifyConfig.getInterval(), DateUtil.now()});
        this.execute(notifyConfig, "\u52a8\u6001\u7ebf\u7a0b\u6c60\u544a\u8b66", text, Lists.newArrayList((Object[])receives));
    }

    @Override
    public void sendChangeMessage(NotifyConfigDTO notifyConfig, ChangeParameterNotifyRequest changeParameterNotifyRequest) {
        String threadPoolId = changeParameterNotifyRequest.getThreadPoolId();
        Object[] receives = notifyConfig.getReceives().split(",");
        String afterReceives = Joiner.on((String)", @").join(receives);
        String text = String.format("**<font color=#2a9d8f>[\u901a\u77e5] </font>%s - \u52a8\u6001\u7ebf\u7a0b\u6c60\u53c2\u6570\u53d8\u66f4** \n\n --- \n\n <font color=#708090 size=2>\u7ebf\u7a0b\u6c60ID\uff1a%s</font> \n\n <font color=#708090 size=2>\u5e94\u7528\u540d\u79f0\uff1a%s</font> \n\n <font color=#778899 size=2>\u5e94\u7528\u5b9e\u4f8b\uff1a%s</font> \n\n  --- \n\n  <font color=#708090 size=2>\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a%s</font> \n\n <font color=#708090 size=2>\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%s</font> \n\n <font color=#708090 size=2>\u6838\u5fc3\u7ebf\u7a0b\u8d85\u65f6\uff1a%s</font> \n\n <font color=#708090 size=2>\u7ebf\u7a0b\u5b58\u6d3b\u65f6\u95f4\uff1a%s</font> \n\n<font color=#708090 size=2>\u6267\u884c\u8d85\u65f6\u65f6\u95f4\uff1a%s</font> \n\n --- \n\n  <font color=#708090 size=2>\u961f\u5217\u7c7b\u578b\uff1a%s</font> \n\n <font color=#708090 size=2>\u961f\u5217\u5bb9\u91cf\uff1a%s</font> \n\n <font color=#708090 size=2>AGO \u62d2\u7edd\u7b56\u7565\uff1a%s</font> \n\n<font color=#708090 size=2>NOW \u62d2\u7edd\u7b56\u7565\uff1a%s</font> \n\n --- \n\n  <font color=#708090 size=2>\u63d0\u793a\uff1a\u52a8\u6001\u7ebf\u7a0b\u6c60\u914d\u7f6e\u53d8\u66f4\u5b9e\u65f6\u901a\u77e5\uff08\u65e0\u9650\u5236\uff09</font> \n\n<font color=#708090 size=2>OWNER\uff1a@%s</font> \n\n --- \n\n  **\u64ad\u62a5\u65f6\u95f4\uff1a%s**", changeParameterNotifyRequest.getActive(), threadPoolId, changeParameterNotifyRequest.getAppName(), changeParameterNotifyRequest.getIdentify(), changeParameterNotifyRequest.getBeforeCorePoolSize() + "  \u27b2  " + changeParameterNotifyRequest.getNowCorePoolSize(), changeParameterNotifyRequest.getBeforeMaximumPoolSize() + "  \u27b2  " + changeParameterNotifyRequest.getNowMaximumPoolSize(), changeParameterNotifyRequest.getBeforeAllowsCoreThreadTimeOut() + "  \u27b2  " + changeParameterNotifyRequest.getNowAllowsCoreThreadTimeOut(), changeParameterNotifyRequest.getBeforeKeepAliveTime() + "  \u27b2  " + changeParameterNotifyRequest.getNowKeepAliveTime(), changeParameterNotifyRequest.getBeforeExecuteTimeOut() + "  \u27b2  " + changeParameterNotifyRequest.getNowExecuteTimeOut(), changeParameterNotifyRequest.getBlockingQueueName(), changeParameterNotifyRequest.getBeforeQueueCapacity() + "  \u27b2  " + changeParameterNotifyRequest.getNowQueueCapacity(), changeParameterNotifyRequest.getBeforeRejectedName(), changeParameterNotifyRequest.getNowRejectedName(), afterReceives, DateUtil.now());
        this.execute(notifyConfig, "\u52a8\u6001\u7ebf\u7a0b\u6c60\u901a\u77e5", text, Lists.newArrayList((Object[])receives));
    }

    private void execute(NotifyConfigDTO notifyConfig, String title, String text, List<String> mobiles) {
        String serverUrl = "https://oapi.dingtalk.com/robot/send?access_token=" + notifyConfig.getSecretKey();
        String secret = notifyConfig.getSecret();
        if (StringUtil.isNotBlank(secret)) {
            long timestamp = System.currentTimeMillis();
            String stringToSign = timestamp + "\n" + secret;
            try {
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
                byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
                String sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), StandardCharsets.UTF_8.name());
                serverUrl = serverUrl + "&timestamp=" + timestamp + "&sign=" + sign;
            }
            catch (Exception ex) {
                log.error("Failed to sign the message sent by nailing.", (Throwable)ex);
            }
        }
        DefaultDingTalkClient dingTalkClient = new DefaultDingTalkClient(serverUrl);
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("markdown");
        OapiRobotSendRequest.Markdown markdown = new OapiRobotSendRequest.Markdown();
        markdown.setTitle(title);
        markdown.setText(text);
        OapiRobotSendRequest.At at = new OapiRobotSendRequest.At();
        at.setAtMobiles(mobiles);
        request.setAt(at);
        request.setMarkdown(markdown);
        try {
            dingTalkClient.execute((TaobaoRequest)request);
        }
        catch (ApiException ex) {
            log.error("Ding failed to send message", (Throwable)ex);
        }
    }
}

