/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.notify.platform;

import cn.hippo4j.common.notify.NotifyConfigDTO;
import cn.hippo4j.common.notify.NotifyPlatformEnum;
import cn.hippo4j.common.notify.NotifyTypeEnum;
import cn.hippo4j.common.notify.SendMessageHandler;
import cn.hippo4j.common.notify.request.AlarmNotifyRequest;
import cn.hippo4j.common.notify.request.ChangeParameterNotifyRequest;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LarkSendMessageHandler
implements SendMessageHandler<AlarmNotifyRequest, ChangeParameterNotifyRequest> {
    private static final Logger log = LoggerFactory.getLogger(LarkSendMessageHandler.class);

    @Override
    public String getType() {
        return NotifyPlatformEnum.LARK.name();
    }

    @Override
    public void sendAlarmMessage(NotifyConfigDTO notifyConfig, AlarmNotifyRequest alarmNotifyRequest) {
        String larkAlarmTxt;
        String afterReceives = this.getReceives(notifyConfig.getReceives());
        if (Objects.equals((Object)alarmNotifyRequest.getNotifyTypeEnum(), (Object)NotifyTypeEnum.TIMEOUT)) {
            String larkAlarmTimoutReplaceTxt;
            String executeTimeoutTrace = alarmNotifyRequest.getExecuteTimeoutTrace();
            if (StringUtil.isNotBlank(executeTimeoutTrace)) {
                String larkAlarmTimoutTraceReplaceTxt = String.format(",{\"is_short\":true,\"text\":{\"content\":\"** \u94fe\u8def\u4fe1\u606f\uff1a** %s\",\"tag\":\"lark_md\"}}", executeTimeoutTrace);
                larkAlarmTimoutReplaceTxt = StrUtil.replace((CharSequence)"{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u8d85\u65f6\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u94fe\u8def\u4fe1\u606f\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},", (CharSequence)",{\"is_short\":true,\"text\":{\"content\":\"** \u94fe\u8def\u4fe1\u606f\uff1a** %s\",\"tag\":\"lark_md\"}}", (CharSequence)larkAlarmTimoutTraceReplaceTxt);
            } else {
                larkAlarmTimoutReplaceTxt = StrUtil.replace((CharSequence)"{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u8d85\u65f6\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u94fe\u8def\u4fe1\u606f\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},", (CharSequence)",{\"is_short\":true,\"text\":{\"content\":\"** \u94fe\u8def\u4fe1\u606f\uff1a** %s\",\"tag\":\"lark_md\"}}", (CharSequence)"");
            }
            larkAlarmTimoutReplaceTxt = String.format(larkAlarmTimoutReplaceTxt, alarmNotifyRequest.getExecuteTime(), alarmNotifyRequest.getExecuteTimeOut());
            larkAlarmTxt = StrUtil.replace((CharSequence)"{\"msg_type\":\"interactive\",\"card\":{\"config\":{\"wide_screen_mode\":true},\"header\":{\"template\":\"red\",\"title\":{\"content\":\"[\ud83d\udd25\u8b66\u62a5] %s \u52a8\u6001\u7ebf\u7a0b\u6c60\u8fd0\u884c\u544a\u8b66\uff08%s\uff09\",\"tag\":\"plain_text\"}},\"elements\":[{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u7ebf\u7a0b\u6c60ID\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u5e94\u7528\u540d\u79f0\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u5e94\u7528\u5b9e\u4f8b\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u6700\u5927\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u5f53\u524d\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u6d3b\u8dc3\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u540c\u5b58\u6700\u5927\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u7ebf\u7a0b\u6c60\u4efb\u52a1\u603b\u91cf\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u961f\u5217\u7c7b\u578b\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u961f\u5217\u5bb9\u91cf\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u961f\u5217\u5143\u7d20\u4e2a\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u961f\u5217\u5269\u4f59\u4e2a\u6570\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u8d85\u65f6\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u94fe\u8def\u4fe1\u606f\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u62d2\u7edd\u7b56\u7565\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u62d2\u7edd\u7b56\u7565\u6267\u884c\u6b21\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** OWNER\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u64ad\u62a5\u65f6\u95f4\uff1a ** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"tag\":\"note\",\"elements\":[{\"tag\":\"plain_text\",\"content\":\"\u63d0\u793a\uff1a %s \u5206\u949f\u5185\u6b64\u7ebf\u7a0b\u6c60\u4e0d\u4f1a\u91cd\u590d\u544a\u8b66\uff08\u53ef\u914d\u7f6e\uff09\"}]}]}}", (CharSequence)"{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u8d85\u65f6\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u94fe\u8def\u4fe1\u606f\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},", (CharSequence)larkAlarmTimoutReplaceTxt);
        } else {
            larkAlarmTxt = StrUtil.replace((CharSequence)"{\"msg_type\":\"interactive\",\"card\":{\"config\":{\"wide_screen_mode\":true},\"header\":{\"template\":\"red\",\"title\":{\"content\":\"[\ud83d\udd25\u8b66\u62a5] %s \u52a8\u6001\u7ebf\u7a0b\u6c60\u8fd0\u884c\u544a\u8b66\uff08%s\uff09\",\"tag\":\"plain_text\"}},\"elements\":[{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u7ebf\u7a0b\u6c60ID\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u5e94\u7528\u540d\u79f0\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u5e94\u7528\u5b9e\u4f8b\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u6700\u5927\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u5f53\u524d\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u6d3b\u8dc3\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u540c\u5b58\u6700\u5927\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u7ebf\u7a0b\u6c60\u4efb\u52a1\u603b\u91cf\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u961f\u5217\u7c7b\u578b\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u961f\u5217\u5bb9\u91cf\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u961f\u5217\u5143\u7d20\u4e2a\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u961f\u5217\u5269\u4f59\u4e2a\u6570\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u8d85\u65f6\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u94fe\u8def\u4fe1\u606f\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u62d2\u7edd\u7b56\u7565\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u62d2\u7edd\u7b56\u7565\u6267\u884c\u6b21\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** OWNER\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u64ad\u62a5\u65f6\u95f4\uff1a ** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"tag\":\"note\",\"elements\":[{\"tag\":\"plain_text\",\"content\":\"\u63d0\u793a\uff1a %s \u5206\u949f\u5185\u6b64\u7ebf\u7a0b\u6c60\u4e0d\u4f1a\u91cd\u590d\u544a\u8b66\uff08\u53ef\u914d\u7f6e\uff09\"}]}]}}", (CharSequence)"{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u8d85\u65f6\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u94fe\u8def\u4fe1\u606f\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},", (CharSequence)"");
        }
        String text = String.format(larkAlarmTxt, new Object[]{alarmNotifyRequest.getActive(), alarmNotifyRequest.getNotifyTypeEnum(), alarmNotifyRequest.getThreadPoolId(), alarmNotifyRequest.getAppName(), alarmNotifyRequest.getIdentify(), alarmNotifyRequest.getCorePoolSize(), alarmNotifyRequest.getMaximumPoolSize(), alarmNotifyRequest.getPoolSize(), alarmNotifyRequest.getActiveCount(), alarmNotifyRequest.getLargestPoolSize(), alarmNotifyRequest.getCompletedTaskCount(), alarmNotifyRequest.getQueueName(), alarmNotifyRequest.getCapacity(), alarmNotifyRequest.getQueueSize(), alarmNotifyRequest.getRemainingCapacity(), alarmNotifyRequest.getRejectedExecutionHandlerName(), alarmNotifyRequest.getRejectCountNum(), afterReceives, DateUtil.now(), notifyConfig.getInterval()});
        this.execute(notifyConfig.getSecretKey(), text);
    }

    @Override
    public void sendChangeMessage(NotifyConfigDTO notifyConfig, ChangeParameterNotifyRequest changeParameterNotifyRequest) {
        String threadPoolId = changeParameterNotifyRequest.getThreadPoolId();
        String afterReceives = this.getReceives(notifyConfig.getReceives());
        String larkNoticeJson = "{\"msg_type\":\"interactive\",\"card\":{\"config\":{\"wide_screen_mode\":true},\"header\":{\"template\":\"greed\",\"title\":{\"content\":\"[\u901a\u77e5] %s \u52a8\u6001\u7ebf\u7a0b\u6c60\u53c2\u6570\u53d8\u66f4\",\"tag\":\"plain_text\"}},\"elements\":[{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u7ebf\u7a0b\u6c60ID\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u5e94\u7528\u540d\u79f0\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u5e94\u7528\u5b9e\u4f8b\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u6700\u5927\u7ebf\u7a0b\u6570\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u6838\u5fc3\u7ebf\u7a0b\u8d85\u65f6\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u7ebf\u7a0b\u5b58\u6d3b\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** \u961f\u5217\u7c7b\u578b\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u961f\u5217\u5bb9\u91cf\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u6267\u884c\u8d85\u65f6\u65f6\u95f4\uff1a** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"fields\":[{\"is_short\":true,\"text\":{\"content\":\"** AGO \u62d2\u7edd\u7b56\u7565\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** NOW \u62d2\u7edd\u7b56\u7565\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** OWNER\uff1a** %s\",\"tag\":\"lark_md\"}},{\"is_short\":true,\"text\":{\"content\":\"** \u64ad\u62a5\u65f6\u95f4\uff1a ** %s\",\"tag\":\"lark_md\"}}],\"tag\":\"div\"},{\"tag\":\"hr\"},{\"tag\":\"note\",\"elements\":[{\"tag\":\"plain_text\",\"content\":\"\u63d0\u793a\uff1a\u52a8\u6001\u7ebf\u7a0b\u6c60\u914d\u7f6e\u53d8\u66f4\u5b9e\u65f6\u901a\u77e5\uff08\u65e0\u9650\u5236\uff09\"}]}]}}";
        String text = String.format(larkNoticeJson, changeParameterNotifyRequest.getActive(), threadPoolId, changeParameterNotifyRequest.getAppName(), changeParameterNotifyRequest.getIdentify(), changeParameterNotifyRequest.getBeforeCorePoolSize() + "  \u27b2  " + changeParameterNotifyRequest.getNowCorePoolSize(), changeParameterNotifyRequest.getBeforeMaximumPoolSize() + "  \u27b2  " + changeParameterNotifyRequest.getNowMaximumPoolSize(), changeParameterNotifyRequest.getBeforeAllowsCoreThreadTimeOut() + "  \u27b2  " + changeParameterNotifyRequest.getNowAllowsCoreThreadTimeOut(), changeParameterNotifyRequest.getBeforeKeepAliveTime() + "  \u27b2  " + changeParameterNotifyRequest.getNowKeepAliveTime(), changeParameterNotifyRequest.getBlockingQueueName(), changeParameterNotifyRequest.getBeforeQueueCapacity() + "  \u27b2  " + changeParameterNotifyRequest.getNowQueueCapacity(), changeParameterNotifyRequest.getBeforeExecuteTimeOut() + "  \u27b2  " + changeParameterNotifyRequest.getNowExecuteTimeOut(), changeParameterNotifyRequest.getBeforeRejectedName(), changeParameterNotifyRequest.getNowRejectedName(), afterReceives, DateUtil.now());
        this.execute(notifyConfig.getSecretKey(), text);
    }

    private String getReceives(String receives) {
        if (StringUtil.isBlank(receives)) {
            return "";
        }
        return Arrays.stream(receives.split(",")).map(receive -> StrUtil.startWith((CharSequence)receive, (CharSequence)"ou_") ? String.format("<at id='%s'></at>", receive) : String.format("<at id=''>%s</at>", receive)).collect(Collectors.joining(" "));
    }

    private void execute(String secretKey, String text) {
        String serverUrl = "https://open.feishu.cn/open-apis/bot/v2/hook/" + secretKey;
        try {
            HttpRequest.post((String)serverUrl).body(text).execute();
        }
        catch (Exception ex) {
            log.error("Lark failed to send message", (Throwable)ex);
        }
    }
}

