/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.notify.platform;

import cn.hippo4j.common.notify.NotifyConfigDTO;
import cn.hippo4j.common.notify.NotifyPlatformEnum;
import cn.hippo4j.common.notify.NotifyTypeEnum;
import cn.hippo4j.common.notify.SendMessageHandler;
import cn.hippo4j.common.notify.request.AlarmNotifyRequest;
import cn.hippo4j.common.notify.request.ChangeParameterNotifyRequest;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.google.common.base.Joiner;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatSendMessageHandler
implements SendMessageHandler<AlarmNotifyRequest, ChangeParameterNotifyRequest> {
    private static final Logger log = LoggerFactory.getLogger(WeChatSendMessageHandler.class);

    @Override
    public String getType() {
        return NotifyPlatformEnum.WECHAT.name();
    }

    @Override
    public void sendAlarmMessage(NotifyConfigDTO notifyConfig, AlarmNotifyRequest alarmNotifyRequest) {
        String weChatAlarmTxt;
        Object[] receives = notifyConfig.getReceives().split(",");
        String afterReceives = Joiner.on((String)"><@").join(receives);
        if (Objects.equals((Object)alarmNotifyRequest.getNotifyTypeEnum(), (Object)NotifyTypeEnum.TIMEOUT)) {
            String weChatAlarmTimoutReplaceTxt;
            String executeTimeoutTrace = alarmNotifyRequest.getExecuteTimeoutTrace();
            if (StringUtil.isNotBlank(executeTimeoutTrace)) {
                String weChatAlarmTimoutTraceReplaceTxt = String.format("> \u94fe\u8def\u4fe1\u606f\uff1a%s \n", executeTimeoutTrace);
                weChatAlarmTimoutReplaceTxt = StrUtil.replace((CharSequence)"> \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%s / ms \n> \u8d85\u65f6\u65f6\u95f4\uff1a%s / ms \n> \u94fe\u8def\u4fe1\u606f\uff1a%s \n", (CharSequence)"> \u94fe\u8def\u4fe1\u606f\uff1a%s \n", (CharSequence)weChatAlarmTimoutTraceReplaceTxt);
            } else {
                weChatAlarmTimoutReplaceTxt = StrUtil.replace((CharSequence)"> \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%s / ms \n> \u8d85\u65f6\u65f6\u95f4\uff1a%s / ms \n> \u94fe\u8def\u4fe1\u606f\uff1a%s \n", (CharSequence)"> \u94fe\u8def\u4fe1\u606f\uff1a%s \n", (CharSequence)"");
            }
            weChatAlarmTimoutReplaceTxt = String.format(weChatAlarmTimoutReplaceTxt, alarmNotifyRequest.getExecuteTime(), alarmNotifyRequest.getExecuteTimeOut());
            weChatAlarmTxt = StrUtil.replace((CharSequence)"### <font color='#FF0000'>[\u8b66\u62a5] </font>%s - \u52a8\u6001\u7ebf\u7a0b\u6c60\u8fd0\u884c\u544a\u8b66\uff08%s\uff09 \n> \u7ebf\u7a0b\u6c60ID\uff1a<font color=\"warning\">%s</font> \n> \u5e94\u7528\u540d\u79f0\uff1a<font color=\"warning\">%s</font> \n> \u5e94\u7528\u5b9e\u4f8b\uff1a%s \n> \u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a%s \n> \u6700\u5927\u7ebf\u7a0b\u6570\uff1a%s \n> \u5f53\u524d\u7ebf\u7a0b\u6570\uff1a%s \n> \u6d3b\u8dc3\u7ebf\u7a0b\u6570\uff1a%s \n> \u540c\u5b58\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%s \n> \u7ebf\u7a0b\u6c60\u4efb\u52a1\u603b\u91cf\uff1a%s \n> \u961f\u5217\u7c7b\u578b\uff1a%s \n> \u961f\u5217\u5bb9\u91cf\uff1a%s \n> \u961f\u5217\u5143\u7d20\u4e2a\u6570\uff1a%s \n> \u961f\u5217\u5269\u4f59\u4e2a\u6570\uff1a%s \n> \u62d2\u7edd\u7b56\u7565\uff1a%s \n> \u62d2\u7edd\u7b56\u7565\u6267\u884c\u6b21\u6570\uff1a<font color='#FF0000'>%s</font> \n> \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%s / ms \n> \u8d85\u65f6\u65f6\u95f4\uff1a%s / ms \n> \u94fe\u8def\u4fe1\u606f\uff1a%s \n> OWNER\uff1a<@%s> \n> \u63d0\u793a\uff1a%d \u5206\u949f\u5185\u6b64\u7ebf\u7a0b\u6c60\u4e0d\u4f1a\u91cd\u590d\u544a\u8b66\uff08\u53ef\u914d\u7f6e\uff09 \n\n**\u64ad\u62a5\u65f6\u95f4\uff1a%s**", (CharSequence)"> \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%s / ms \n> \u8d85\u65f6\u65f6\u95f4\uff1a%s / ms \n> \u94fe\u8def\u4fe1\u606f\uff1a%s \n", (CharSequence)weChatAlarmTimoutReplaceTxt);
        } else {
            weChatAlarmTxt = StrUtil.replace((CharSequence)"### <font color='#FF0000'>[\u8b66\u62a5] </font>%s - \u52a8\u6001\u7ebf\u7a0b\u6c60\u8fd0\u884c\u544a\u8b66\uff08%s\uff09 \n> \u7ebf\u7a0b\u6c60ID\uff1a<font color=\"warning\">%s</font> \n> \u5e94\u7528\u540d\u79f0\uff1a<font color=\"warning\">%s</font> \n> \u5e94\u7528\u5b9e\u4f8b\uff1a%s \n> \u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a%s \n> \u6700\u5927\u7ebf\u7a0b\u6570\uff1a%s \n> \u5f53\u524d\u7ebf\u7a0b\u6570\uff1a%s \n> \u6d3b\u8dc3\u7ebf\u7a0b\u6570\uff1a%s \n> \u540c\u5b58\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%s \n> \u7ebf\u7a0b\u6c60\u4efb\u52a1\u603b\u91cf\uff1a%s \n> \u961f\u5217\u7c7b\u578b\uff1a%s \n> \u961f\u5217\u5bb9\u91cf\uff1a%s \n> \u961f\u5217\u5143\u7d20\u4e2a\u6570\uff1a%s \n> \u961f\u5217\u5269\u4f59\u4e2a\u6570\uff1a%s \n> \u62d2\u7edd\u7b56\u7565\uff1a%s \n> \u62d2\u7edd\u7b56\u7565\u6267\u884c\u6b21\u6570\uff1a<font color='#FF0000'>%s</font> \n> \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%s / ms \n> \u8d85\u65f6\u65f6\u95f4\uff1a%s / ms \n> \u94fe\u8def\u4fe1\u606f\uff1a%s \n> OWNER\uff1a<@%s> \n> \u63d0\u793a\uff1a%d \u5206\u949f\u5185\u6b64\u7ebf\u7a0b\u6c60\u4e0d\u4f1a\u91cd\u590d\u544a\u8b66\uff08\u53ef\u914d\u7f6e\uff09 \n\n**\u64ad\u62a5\u65f6\u95f4\uff1a%s**", (CharSequence)"> \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%s / ms \n> \u8d85\u65f6\u65f6\u95f4\uff1a%s / ms \n> \u94fe\u8def\u4fe1\u606f\uff1a%s \n", (CharSequence)"");
        }
        String text = String.format(weChatAlarmTxt, new Object[]{alarmNotifyRequest.getActive(), alarmNotifyRequest.getNotifyTypeEnum(), alarmNotifyRequest.getThreadPoolId(), alarmNotifyRequest.getAppName(), alarmNotifyRequest.getIdentify(), alarmNotifyRequest.getCorePoolSize(), alarmNotifyRequest.getMaximumPoolSize(), alarmNotifyRequest.getPoolSize(), alarmNotifyRequest.getActiveCount(), alarmNotifyRequest.getLargestPoolSize(), alarmNotifyRequest.getCompletedTaskCount(), alarmNotifyRequest.getQueueName(), alarmNotifyRequest.getCapacity(), alarmNotifyRequest.getQueueSize(), alarmNotifyRequest.getRemainingCapacity(), alarmNotifyRequest.getRejectedExecutionHandlerName(), alarmNotifyRequest.getRejectCountNum(), afterReceives, notifyConfig.getInterval(), DateUtil.now()});
        this.execute(notifyConfig.getSecretKey(), text);
    }

    @Override
    public void sendChangeMessage(NotifyConfigDTO notifyConfig, ChangeParameterNotifyRequest changeParameterNotifyRequest) {
        String threadPoolId = changeParameterNotifyRequest.getThreadPoolId();
        Object[] receives = notifyConfig.getReceives().split(",");
        String afterReceives = Joiner.on((String)"><@").join(receives);
        String text = String.format("### <font color=\"info\">[\u901a\u77e5] </font>%s - \u52a8\u6001\u7ebf\u7a0b\u6c60\u53c2\u6570\u53d8\u66f4 \n> \u7ebf\u7a0b\u6c60ID\uff1a<font color=\"warning\">%s</font> \n> \u5e94\u7528\u540d\u79f0\uff1a<font color=\"warning\">%s</font> \n> \u5e94\u7528\u5b9e\u4f8b\uff1a%s \n> \u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a%s \n> \u6700\u5927\u7ebf\u7a0b\u6570\uff1a%s \n> \u6838\u5fc3\u7ebf\u7a0b\u8d85\u65f6\uff1a%s \n> \u7ebf\u7a0b\u5b58\u6d3b\u65f6\u95f4\uff1a%s \n> \u6267\u884c\u8d85\u65f6\u65f6\u95f4\uff1a%s \n> \u961f\u5217\u7c7b\u578b\uff1a%s \n> \u961f\u5217\u5bb9\u91cf\uff1a%s \n> AGO \u62d2\u7edd\u7b56\u7565\uff1a%s \n> NOW \u62d2\u7edd\u7b56\u7565\uff1a%s \n> OWNER\uff1a<@%s> \n> \u63d0\u793a\uff1a\u52a8\u6001\u7ebf\u7a0b\u6c60\u914d\u7f6e\u53d8\u66f4\u5b9e\u65f6\u901a\u77e5\uff08\u65e0\u9650\u5236\uff09 \n\n**\u64ad\u62a5\u65f6\u95f4\uff1a%s**", changeParameterNotifyRequest.getActive(), threadPoolId, changeParameterNotifyRequest.getAppName(), changeParameterNotifyRequest.getIdentify(), changeParameterNotifyRequest.getBeforeCorePoolSize() + "  \u27b2  " + changeParameterNotifyRequest.getNowCorePoolSize(), changeParameterNotifyRequest.getBeforeMaximumPoolSize() + "  \u27b2  " + changeParameterNotifyRequest.getNowMaximumPoolSize(), changeParameterNotifyRequest.getBeforeAllowsCoreThreadTimeOut() + "  \u27b2  " + changeParameterNotifyRequest.getNowAllowsCoreThreadTimeOut(), changeParameterNotifyRequest.getBeforeKeepAliveTime() + "  \u27b2  " + changeParameterNotifyRequest.getNowKeepAliveTime(), changeParameterNotifyRequest.getBeforeExecuteTimeOut() + "  \u27b2  " + changeParameterNotifyRequest.getNowExecuteTimeOut(), changeParameterNotifyRequest.getBlockingQueueName(), changeParameterNotifyRequest.getBeforeQueueCapacity() + "  \u27b2  " + changeParameterNotifyRequest.getNowQueueCapacity(), changeParameterNotifyRequest.getBeforeRejectedName(), changeParameterNotifyRequest.getNowRejectedName(), afterReceives, DateUtil.now());
        this.execute(notifyConfig.getSecretKey(), text);
    }

    private void execute(String secretKey, String text) {
        String serverUrl = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=" + secretKey;
        try {
            WeChatReqDTO weChatReq = new WeChatReqDTO();
            weChatReq.setMsgtype("markdown");
            Markdown markdown = new Markdown();
            markdown.setContent(text);
            weChatReq.setMarkdown(markdown);
            HttpRequest.post((String)serverUrl).body(JSONUtil.toJSONString(weChatReq)).execute();
        }
        catch (Exception ex) {
            log.error("WeChat failed to send message", (Throwable)ex);
        }
    }

    public static class Markdown {
        private String content;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Markdown)) {
                return false;
            }
            Markdown other = (Markdown)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Markdown;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        public String toString() {
            return "WeChatSendMessageHandler.Markdown(content=" + this.getContent() + ")";
        }
    }

    public static class WeChatReqDTO {
        private String msgtype;
        private Markdown markdown;

        public String getMsgtype() {
            return this.msgtype;
        }

        public Markdown getMarkdown() {
            return this.markdown;
        }

        public WeChatReqDTO setMsgtype(String msgtype) {
            this.msgtype = msgtype;
            return this;
        }

        public WeChatReqDTO setMarkdown(Markdown markdown) {
            this.markdown = markdown;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeChatReqDTO)) {
                return false;
            }
            WeChatReqDTO other = (WeChatReqDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$msgtype = this.getMsgtype();
            String other$msgtype = other.getMsgtype();
            if (this$msgtype == null ? other$msgtype != null : !this$msgtype.equals(other$msgtype)) {
                return false;
            }
            Markdown this$markdown = this.getMarkdown();
            Markdown other$markdown = other.getMarkdown();
            return !(this$markdown == null ? other$markdown != null : !((Object)this$markdown).equals(other$markdown));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WeChatReqDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $msgtype = this.getMsgtype();
            result = result * 59 + ($msgtype == null ? 43 : $msgtype.hashCode());
            Markdown $markdown = this.getMarkdown();
            result = result * 59 + ($markdown == null ? 43 : ((Object)$markdown).hashCode());
            return result;
        }

        public String toString() {
            return "WeChatSendMessageHandler.WeChatReqDTO(msgtype=" + this.getMsgtype() + ", markdown=" + this.getMarkdown() + ")";
        }
    }
}

