/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit;

import cn.hippo4j.common.toolkit.ArrayUtil;
import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.common.toolkit.StringUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectUtil {
    private static final Map<Class<?>, Field[]> FIELDS_CACHE = new ConcurrentHashMap();

    public static Object getFieldValue(Object obj, String fieldName) {
        if (null == obj || StringUtil.isBlank(fieldName)) {
            return null;
        }
        Field field = ReflectUtil.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        return ReflectUtil.getFieldValue(obj, field);
    }

    public static Object getFieldValue(Object obj, Field field) {
        Object result;
        if (null == field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        ReflectUtil.setAccessible(field);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            String exceptionMsg = String.format("IllegalAccess for %s.%s", field.getDeclaringClass(), field.getName());
            throw new RuntimeException(exceptionMsg, e);
        }
        return result;
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = ReflectUtil.getFields(beanClass);
        return ArrayUtil.firstMatch(field -> name.equals(ReflectUtil.getFieldName(field)), fields);
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Field[] allFields = FIELDS_CACHE.get(beanClass);
        if (null != allFields) {
            return allFields;
        }
        allFields = ReflectUtil.getFieldsDirectly(beanClass, true);
        FIELDS_CACHE.put(beanClass, allFields);
        return allFields;
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        Assert.notNull(beanClass);
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            if (null == allFields) {
                allFields = declaredFields;
            } else {
                int length = allFields.length;
                allFields = Arrays.copyOf(allFields, length + declaredFields.length);
                for (int i = 1; i < declaredFields.length; ++i) {
                    allFields[length + i] = declaredFields[i - 1];
                }
            }
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static String getFieldName(Field field) {
        if (null == field) {
            return null;
        }
        return field.getName();
    }
}

