/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit;

import cn.hippo4j.common.toolkit.ArrayUtil;

public class StringUtil {
    public static final String EMPTY = "";
    public static final char UNDERLINE = '_';

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            boolean charNotBlank;
            char c = str.charAt(i);
            boolean bl = charNotBlank = Character.isWhitespace(c) || Character.isSpaceChar(c) || c == '\ufeff' || c == '\u202a';
            if (charNotBlank) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isNotBlank(CharSequence str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean isAllNotEmpty(CharSequence ... args) {
        return false == StringUtil.hasEmpty(args);
    }

    public static boolean hasEmpty(CharSequence ... strList) {
        if (ArrayUtil.isEmpty(strList)) {
            return true;
        }
        for (CharSequence str : strList) {
            if (!StringUtil.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static String toUnderlineCase(CharSequence str) {
        return StringUtil.toSymbolCase(str, '_');
    }

    public static String toSymbolCase(CharSequence str, char symbol) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            Character preChar;
            char c = str.charAt(i);
            Character c2 = preChar = i > 0 ? Character.valueOf(str.charAt(i - 1)) : null;
            if (Character.isUpperCase(c)) {
                Character nextChar;
                Character c3 = nextChar = i < str.length() - 1 ? Character.valueOf(str.charAt(i + 1)) : null;
                if (null != preChar && Character.isUpperCase(preChar.charValue())) {
                    sb.append(c);
                    continue;
                }
                if (null != nextChar && Character.isUpperCase(nextChar.charValue())) {
                    if (null != preChar && symbol != preChar.charValue()) {
                        sb.append(symbol);
                    }
                    sb.append(c);
                    continue;
                }
                if (null != preChar && symbol != preChar.charValue()) {
                    sb.append(symbol);
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (sb.length() > 0 && Character.isUpperCase(sb.charAt(sb.length() - 1)) && symbol != c) {
                sb.append(symbol);
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

