/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.constant;

import cn.hippo4j.common.toolkit.StringUtil;

public final class HttpMediaType {
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded;charset=UTF-8";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final String APPLICATION_XML = "application/xml;charset=UTF-8";
    public static final String APPLICATION_JSON = "application/json;charset=UTF-8";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data;charset=UTF-8";
    public static final String TEXT_HTML = "text/html;charset=UTF-8";
    public static final String TEXT_PLAIN = "text/plain;charset=UTF-8";
    private final String type;
    private final String charset;

    private HttpMediaType(String type, String charset) {
        this.type = type;
        this.charset = charset;
    }

    public static HttpMediaType valueOf(String contentType) {
        if (StringUtil.isEmpty(contentType)) {
            throw new IllegalArgumentException("MediaType must not be empty");
        }
        String[] values = contentType.split(";");
        String charset = "UTF-8";
        for (String value : values) {
            if (!value.startsWith("charset=")) continue;
            charset = value.substring("charset=".length());
        }
        return new HttpMediaType(values[0], charset);
    }

    public static HttpMediaType valueOf(String contentType, String charset) {
        if (StringUtil.isEmpty(contentType)) {
            throw new IllegalArgumentException("MediaType must not be empty");
        }
        String[] values = contentType.split(";");
        return new HttpMediaType(values[0], StringUtil.isEmpty(charset) ? "UTF-8" : charset);
    }

    public String getType() {
        return this.type;
    }

    public String getCharset() {
        return this.charset;
    }

    public String toString() {
        return this.type + ";charset=" + this.charset;
    }
}

