/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.executor.support;

import cn.hippo4j.common.executor.support.CustomBlockingQueue;
import cn.hippo4j.common.executor.support.ResizableCapacityLinkedBlockingQueue;
import cn.hippo4j.common.spi.DynamicThreadPoolServiceLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.stream.Stream;
import lombok.Generated;

public enum BlockingQueueTypeEnum {
    ARRAY_BLOCKING_QUEUE(1, "ArrayBlockingQueue"),
    LINKED_BLOCKING_QUEUE(2, "LinkedBlockingQueue"),
    LINKED_BLOCKING_DEQUE(3, "LinkedBlockingDeque"),
    SYNCHRONOUS_QUEUE(4, "SynchronousQueue"),
    LINKED_TRANSFER_QUEUE(5, "LinkedTransferQueue"),
    PRIORITY_BLOCKING_QUEUE(6, "PriorityBlockingQueue"),
    RESIZABLE_LINKED_BLOCKING_QUEUE(9, "ResizableCapacityLinkedBlockingQueue");

    private Integer type;
    private String name;
    private static final int DEFAULT_CAPACITY = 1024;

    private BlockingQueueTypeEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public static BlockingQueue createBlockingQueue(String blockingQueueName, Integer capacity) {
        BlockingQueue blockingQueue = null;
        BlockingQueueTypeEnum queueTypeEnum = Stream.of(BlockingQueueTypeEnum.values()).filter(each -> Objects.equals(each.name, blockingQueueName)).findFirst().orElse(null);
        if (queueTypeEnum != null && Objects.equals((blockingQueue = BlockingQueueTypeEnum.createBlockingQueue(queueTypeEnum.type, capacity)).getClass().getSimpleName(), blockingQueueName)) {
            return blockingQueue;
        }
        Collection<CustomBlockingQueue> customBlockingQueues = DynamicThreadPoolServiceLoader.getSingletonServiceInstances(CustomBlockingQueue.class);
        blockingQueue = Optional.ofNullable(blockingQueue).orElseGet(() -> customBlockingQueues.stream().filter(each -> Objects.equals(blockingQueueName, each.getName())).map(each -> each.generateBlockingQueue()).findFirst().orElseGet(() -> {
            int temCapacity = capacity;
            if (capacity == null || capacity <= 0) {
                temCapacity = 1024;
            }
            return new LinkedBlockingQueue(temCapacity);
        }));
        return blockingQueue;
    }

    public static BlockingQueue createBlockingQueue(int type, Integer capacity) {
        BlockingQueue blockingQueue = null;
        if (Objects.equals(type, BlockingQueueTypeEnum.ARRAY_BLOCKING_QUEUE.type)) {
            blockingQueue = new ArrayBlockingQueue(capacity);
        } else if (Objects.equals(type, BlockingQueueTypeEnum.LINKED_BLOCKING_QUEUE.type)) {
            blockingQueue = new LinkedBlockingQueue(capacity);
        } else if (Objects.equals(type, BlockingQueueTypeEnum.LINKED_BLOCKING_DEQUE.type)) {
            blockingQueue = new LinkedBlockingDeque(capacity);
        } else if (Objects.equals(type, BlockingQueueTypeEnum.SYNCHRONOUS_QUEUE.type)) {
            blockingQueue = new SynchronousQueue();
        } else if (Objects.equals(type, BlockingQueueTypeEnum.LINKED_TRANSFER_QUEUE.type)) {
            blockingQueue = new LinkedTransferQueue();
        } else if (Objects.equals(type, BlockingQueueTypeEnum.PRIORITY_BLOCKING_QUEUE.type)) {
            blockingQueue = new PriorityBlockingQueue(capacity);
        } else if (Objects.equals(type, BlockingQueueTypeEnum.RESIZABLE_LINKED_BLOCKING_QUEUE.type)) {
            blockingQueue = new ResizableCapacityLinkedBlockingQueue(capacity);
        }
        Collection<CustomBlockingQueue> customBlockingQueues = DynamicThreadPoolServiceLoader.getSingletonServiceInstances(CustomBlockingQueue.class);
        blockingQueue = Optional.ofNullable(blockingQueue).orElseGet(() -> customBlockingQueues.stream().filter(each -> Objects.equals(type, each.getType())).map(each -> each.generateBlockingQueue()).findFirst().orElse(new LinkedBlockingQueue(capacity)));
        return blockingQueue;
    }

    public static String getBlockingQueueNameByType(int type) {
        Optional<BlockingQueueTypeEnum> queueTypeEnum = Arrays.stream(BlockingQueueTypeEnum.values()).filter(each -> each.type == type).findFirst();
        return queueTypeEnum.map(each -> each.name).orElse("");
    }

    public static BlockingQueueTypeEnum getBlockingQueueTypeEnumByName(String name) {
        Optional<BlockingQueueTypeEnum> queueTypeEnum = Arrays.stream(BlockingQueueTypeEnum.values()).filter(each -> each.name.equals(name)).findFirst();
        return queueTypeEnum.orElse(LINKED_BLOCKING_QUEUE);
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    static {
        DynamicThreadPoolServiceLoader.register(CustomBlockingQueue.class);
    }
}

