/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class CollectionUtil {
    public static <T> T getFirst(Iterable<T> iterable) {
        Iterator<T> iterator;
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNotEmpty(List<?> list) {
        return !CollectionUtil.isEmpty(list);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtil.isEmpty(map);
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return null == iterator || !iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return !CollectionUtil.isEmpty(iterator);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtil.isEmpty(collection);
    }

    public static <T> List<T> toList(T ... ts) {
        if (ts == null || ts.length == 0) {
            return new ArrayList();
        }
        return Arrays.stream(ts).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        Objects.requireNonNull(elements);
        int capacity = CollectionUtil.computeArrayListCapacity(elements.length);
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, elements);
        return list;
    }

    private static int computeArrayListCapacity(int arraySize) {
        CollectionUtil.checkNonnegative(arraySize);
        return CollectionUtil.saturatedCast(5L + (long)arraySize + (long)(arraySize / 10));
    }

    private static void checkNonnegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("arraySize cannot be negative but was: " + value);
        }
    }

    private static int saturatedCast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }
}

