/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit;

import cn.hippo4j.common.toolkit.ArrayUtil;
import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.common.web.exception.IllegalException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class ReflectUtil {
    private static final Map<Class<?>, Field[]> FIELDS_CACHE = new ConcurrentHashMap();

    public static Object getFieldValue(Object obj, String fieldName) {
        if (null == obj || StringUtil.isBlank(fieldName)) {
            return null;
        }
        Field field = ReflectUtil.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        return ReflectUtil.getFieldValue(obj, field);
    }

    public static Object getFieldValue(Object obj, Field field) {
        Object result;
        if (null == field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        ReflectUtil.setAccessible(field);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            String exceptionMsg = String.format("IllegalAccess for %s.%s", field.getDeclaringClass(), field.getName());
            throw new IllegalException(exceptionMsg, e);
        }
        return result;
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = ReflectUtil.getFields(beanClass);
        return ArrayUtil.firstMatch(field -> name.equals(ReflectUtil.getFieldName(field)), fields);
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Field[] allFields = FIELDS_CACHE.get(beanClass);
        if (null != allFields) {
            return allFields;
        }
        allFields = ReflectUtil.getFieldsDirectly(beanClass, true);
        FIELDS_CACHE.put(beanClass, allFields);
        return allFields;
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        Assert.notNull(beanClass);
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            if (null == allFields) {
                allFields = declaredFields;
            } else {
                int length = allFields.length;
                allFields = Arrays.copyOf(allFields, length + declaredFields.length);
                System.arraycopy(declaredFields, 0, allFields, length, declaredFields.length);
            }
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static String getFieldName(Field field) {
        if (null == field) {
            return null;
        }
        return field.getName();
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws IllegalException {
        Assert.notNull(obj);
        Assert.notBlank(fieldName);
        Field field = ReflectUtil.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        Assert.notNull(field, "Field [" + fieldName + "] is not exist in [" + obj.getClass().getName() + "]");
        ReflectUtil.setFieldValue(obj, field, value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws IllegalException {
        Assert.notNull(field, "Field in [" + obj + "] not exist !");
        Class<?> fieldType = field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = ReflectUtil.cast(fieldType, value))) {
                value = targetValue;
            }
        } else {
            value = ReflectUtil.getDefaultValue(fieldType);
        }
        ReflectUtil.setAccessible(field);
        try {
            field.set(obj instanceof Class ? null : obj, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalException("IllegalAccess for " + obj + "." + field.getName(), e);
        }
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) {
        if (Objects.nonNull(clazz) && Objects.nonNull(methodName)) {
            Method method = Arrays.stream(clazz.getMethods()).filter(m -> Objects.equals(m.getName(), methodName)).findFirst().orElse(null);
            if (method != null) {
                return method;
            }
            return Arrays.stream(clazz.getDeclaredMethods()).filter(m -> Objects.equals(m.getName(), methodName)).findFirst().orElse(null);
        }
        return null;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName, Class<?> ... arguments) {
        try {
            if (Objects.nonNull(clazz) && Objects.nonNull(methodName)) {
                return clazz.getMethod(methodName, arguments);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalException(e);
        }
        return null;
    }

    public static Object cast(Class<?> clazz, Object value) {
        try {
            return clazz.cast(value);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (Objects.isNull(clazz) || !clazz.isPrimitive()) {
            return null;
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return 0L;
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return 0;
        }
        if (Short.TYPE.isAssignableFrom(clazz)) {
            return (short)0;
        }
        if (Character.TYPE.isAssignableFrom(clazz)) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            return (byte)0;
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            return 0.0;
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            return Float.valueOf(0.0f);
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            return false;
        }
        return null;
    }

    public static <T> T invoke(Object obj, Method method, Object ... arguments) {
        try {
            return (T)method.invoke(obj, arguments);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalException(e);
        }
    }

    public static Object createInstance(Class<?> cls) {
        try {
            return cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalException(e);
        }
    }

    @Generated
    private ReflectUtil() {
    }
}

