/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit;

import java.util.Optional;
import lombok.Generated;

public class UserContext {
    private static final ThreadLocal<User> USER_THREAD_LOCAL = new ThreadLocal();

    public static void setUserInfo(String username, String userRole) {
        USER_THREAD_LOCAL.set(new User(username, userRole));
    }

    public static String getUserName() {
        return Optional.ofNullable(USER_THREAD_LOCAL.get()).map(User::getUsername).orElse("");
    }

    public static String getUserRole() {
        return Optional.ofNullable(USER_THREAD_LOCAL.get()).map(User::getUserRole).orElse("");
    }

    public static void clear() {
        USER_THREAD_LOCAL.remove();
    }

    static class User {
        private String username;
        private String userRole;

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getUserRole() {
            return this.userRole;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setUserRole(String userRole) {
            this.userRole = userRole;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof User)) {
                return false;
            }
            User other = (User)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$userRole = this.getUserRole();
            String other$userRole = other.getUserRole();
            return !(this$userRole == null ? other$userRole != null : !this$userRole.equals(other$userRole));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof User;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $userRole = this.getUserRole();
            result = result * 59 + ($userRole == null ? 43 : $userRole.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UserContext.User(username=" + this.getUsername() + ", userRole=" + this.getUserRole() + ")";
        }

        @Generated
        public User() {
        }

        @Generated
        public User(String username, String userRole) {
            this.username = username;
            this.userRole = userRole;
        }
    }
}

