/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit.http;

import cn.hippo4j.common.constant.HttpResponseCode;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.toolkit.IoUtil;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.common.toolkit.http.HttpClientResponse;
import cn.hippo4j.common.toolkit.http.JdkHttpClientResponse;
import cn.hippo4j.common.toolkit.logtracing.LogMessage;
import cn.hippo4j.common.web.exception.ServiceException;
import java.io.Closeable;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    private static final int DEFAULT_READ_TIMEOUT = 30000;

    public static <T> T get(String url, Map<String, String> headers, Map<String, String> params, long timeout, Class<T> clazz) {
        return HttpUtil.execute(HttpUtil.buildUrl(url, params), "GET", null, headers, timeout, clazz);
    }

    public static String get(String url, Map<String, String> params) {
        return HttpUtil.execute(HttpUtil.buildUrl(url, params), "GET", null, null);
    }

    public static String get(String url) {
        return HttpUtil.execute(url, "GET", null, null);
    }

    public static <T> T get(String url, Class<T> clazz) {
        return JSONUtil.parseObject(HttpUtil.get(url), clazz);
    }

    public static <T> T post(String url, Object body, Class<T> clazz) {
        String result = HttpUtil.post(url, body);
        return JSONUtil.parseObject(result, clazz);
    }

    public static <T> T post(String url, Object body, long timeout, Class<T> clazz) {
        String result = HttpUtil.post(url, body, timeout);
        return JSONUtil.parseObject(result, clazz);
    }

    public static <T> T post(String url, Map<String, String> headers, Map<String, String> params, long timeout, Class<T> clazz) {
        return HttpUtil.execute(HttpUtil.buildUrl(url, params), "POST", null, headers, timeout, clazz);
    }

    public static <T> T post(String url, Map<String, String> headers, Object body, long timeout, Class<T> clazz) {
        return HttpUtil.execute(url, "POST", body, headers, timeout, clazz);
    }

    public static String post(String url, Object body) {
        return HttpUtil.execute(url, "POST", body, null);
    }

    public static String post(String url, Object body, long timeout) {
        return HttpUtil.execute(url, "POST", body, null, timeout, String.class);
    }

    public static String postJson(String url, String json) {
        return HttpUtil.executeJson(url, "POST", json, null);
    }

    public static String put(String url, Object body) {
        return HttpUtil.execute(url, "PUT", body, null);
    }

    public static String put(String url, Object body, Map<String, String> headers) {
        return HttpUtil.execute(url, "PUT", body, headers);
    }

    public static String buildUrl(String url, Map<String, String> queryParams) {
        if (CollectionUtil.isEmpty(queryParams)) {
            return url;
        }
        boolean isFirst = true;
        StringBuilder builder = new StringBuilder(url);
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            String key = entry.getKey();
            if (key == null || entry.getValue() == null) continue;
            if (isFirst) {
                isFirst = false;
                builder.append("?");
            } else {
                builder.append("&");
            }
            String value = URLEncoder.encode(queryParams.get(key), "UTF-8").replaceAll("\\+", "%20");
            builder.append(key).append("=").append(value);
        }
        return builder.toString();
    }

    private static String executeJson(String url, String method, String json, Map<String, String> headers) {
        if (!JSONUtil.isJson(json)) {
            log.error(LogMessage.getInstance().setMsg("Http Call error.").kv("url", url).kv("method", method).kv("json", json).kv2String("headers", JSONUtil.toJSONString(headers)));
            throw new ServiceException("Invalid http json body, please check it again.");
        }
        return HttpUtil.execute(url, method, json, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String execute(String url, String method, Object param, Map<String, String> headers) {
        HttpURLConnection connection = HttpUtil.createConnection(url, method);
        HttpClientResponse response = null;
        try {
            response = HttpUtil.doExecute(connection, param, headers);
            String string = response.getBodyString();
            return string;
        }
        finally {
            Optional.ofNullable(response).ifPresent(each -> each.close());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T execute(String url, String method, Object body, Map<String, String> headers, long timeout, Class<T> clazz) {
        HttpURLConnection connection = HttpUtil.createConnection(url, method, timeout);
        HttpClientResponse response = null;
        try {
            response = HttpUtil.doExecute(connection, body, headers);
            if (clazz == String.class) {
                String string = response.getBodyString();
                return (T)string;
            }
            T t = JSONUtil.parseObject(response.getBodyString(), clazz);
            return t;
        }
        finally {
            Optional.ofNullable(response).ifPresent(each -> each.close());
        }
    }

    private static HttpClientResponse doExecute(HttpURLConnection connection, Object body, Map<String, String> headers) {
        try {
            String bodyString;
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (!StringUtil.isEmpty(bodyString = body instanceof String ? (String)body : JSONUtil.toJSONString(body))) {
                connection.setDoOutput(true);
                byte[] b = bodyString.getBytes();
                connection.setRequestProperty("Content-Length", String.valueOf(b.length));
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(b, 0, b.length);
                outputStream.flush();
                IoUtil.closeQuietly((Closeable)outputStream);
            }
            connection.connect();
            JdkHttpClientResponse response = new JdkHttpClientResponse(connection);
            if (!HttpResponseCode.isOk(response.getStatusCode())) {
                String msg = String.format("HttpPost response code error. [code] %s [url] %s [body] %s", response.getStatusCode(), connection.getURL(), response.getBodyString());
                throw new ServiceException(msg);
            }
            return response;
        }
        catch (Throwable ex) {
            log.error(LogMessage.getInstance().setMsg("Http call error. ").kv("url", connection.getURL()).kv("method", connection.getRequestMethod()).kv("body", JSONUtil.toJSONString(body)).kv2String("headers", JSONUtil.toJSONString(headers)), ex);
            throw ex;
        }
    }

    private static HttpURLConnection createConnection(String url, String method) {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(30000);
        connection.setRequestMethod(method);
        connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        return connection;
    }

    private static HttpURLConnection createConnection(String url, String method, long timeout) {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setConnectTimeout(Integer.parseInt(String.valueOf(timeout)));
        connection.setReadTimeout(Integer.parseInt(String.valueOf(timeout)));
        connection.setRequestMethod(method);
        connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        return connection;
    }

    @Generated
    private HttpUtil() {
    }
}

