/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.monitor;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.design.builder.ThreadFactoryBuilder;
import cn.hippo4j.common.extension.support.ServiceLoaderRegistry;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.config.springboot.starter.config.BootstrapConfigProperties;
import cn.hippo4j.config.springboot.starter.config.MonitorProperties;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.monitor.base.DynamicThreadPoolMonitor;
import cn.hippo4j.monitor.base.ThreadPoolMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class ThreadPoolMonitorExecutor
implements ApplicationRunner,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolMonitorExecutor.class);
    private final BootstrapConfigProperties properties;
    private ScheduledThreadPoolExecutor collectScheduledExecutor;
    private List<ThreadPoolMonitor> threadPoolMonitors;

    public void run(ApplicationArguments args) throws Exception {
        MonitorProperties monitor = this.properties.getMonitor();
        if (monitor == null || !monitor.getEnable().booleanValue() || StringUtil.isBlank((CharSequence)monitor.getThreadPoolTypes()) || StringUtil.isBlank((CharSequence)monitor.getCollectTypes())) {
            return;
        }
        log.info("Start monitoring the running status of dynamic thread pool.");
        this.threadPoolMonitors = new ArrayList<ThreadPoolMonitor>();
        this.collectScheduledExecutor = new ScheduledThreadPoolExecutor(1, ThreadFactoryBuilder.builder().daemon(true).prefix("client.scheduled.collect.data").build());
        List<String> collectTypes = Arrays.asList(monitor.getCollectTypes().split(","));
        ApplicationContextHolder.getBeansOfType(ThreadPoolMonitor.class).forEach((beanName, bean) -> this.threadPoolMonitors.add((ThreadPoolMonitor)bean));
        Collection dynamicThreadPoolMonitors = ServiceLoaderRegistry.getSingletonServiceInstances(DynamicThreadPoolMonitor.class);
        dynamicThreadPoolMonitors.stream().filter(each -> collectTypes.contains(each.getType())).forEach(each -> this.threadPoolMonitors.add((ThreadPoolMonitor)each));
        this.collectScheduledExecutor.scheduleWithFixedDelay(this::scheduleRunnable, monitor.getInitialDelay(), monitor.getCollectInterval(), TimeUnit.MILLISECONDS);
        if (GlobalThreadPoolManage.getThreadPoolNum() > 0) {
            log.info("Dynamic thread pool: [{}]. The dynamic thread pool starts data collection and reporting.", (Object)GlobalThreadPoolManage.getThreadPoolNum());
        }
    }

    private void scheduleRunnable() {
        for (ThreadPoolMonitor each : this.threadPoolMonitors) {
            try {
                each.collect();
            }
            catch (Exception ex) {
                log.error("Error monitoring the running status of dynamic thread pool. Type: {}", (Object)each.getType(), (Object)ex);
            }
        }
    }

    public void destroy() throws Exception {
        Optional.ofNullable(this.collectScheduledExecutor).ifPresent(ScheduledThreadPoolExecutor::shutdown);
    }

    @Generated
    public ThreadPoolMonitorExecutor(BootstrapConfigProperties properties) {
        this.properties = properties;
    }
}

