/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.refresher;

import cn.hippo4j.common.api.ThreadPoolDynamicRefresh;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.config.springboot.starter.config.BootstrapConfigProperties;
import cn.hippo4j.config.springboot.starter.parser.ConfigParserHandler;
import cn.hippo4j.config.springboot.starter.refresher.BootstrapConfigPropertiesBinderAdapt;
import cn.hippo4j.config.springboot.starter.refresher.event.Hippo4jConfigDynamicRefreshEvent;
import cn.hippo4j.core.executor.support.ThreadPoolBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractConfigThreadPoolDynamicRefresh
implements ThreadPoolDynamicRefresh,
InitializingBean,
ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigThreadPoolDynamicRefresh.class);
    private final BootstrapConfigPropertiesBinderAdapt bootstrapConfigPropertiesBinderAdapt;
    protected BootstrapConfigProperties bootstrapConfigProperties;
    protected final ExecutorService dynamicRefreshExecutorService = ThreadPoolBuilder.builder().singlePool("client.dynamic.refresh").build();

    public AbstractConfigThreadPoolDynamicRefresh() {
        this.bootstrapConfigProperties = (BootstrapConfigProperties)ApplicationContextHolder.getBean(BootstrapConfigProperties.class);
        this.bootstrapConfigPropertiesBinderAdapt = (BootstrapConfigPropertiesBinderAdapt)ApplicationContextHolder.getBean(BootstrapConfigPropertiesBinderAdapt.class);
    }

    protected abstract void initRegisterListener();

    public void dynamicRefresh(String configContent) {
        this.dynamicRefresh(configContent, null);
    }

    public void dynamicRefresh(String configContent, Map<String, Object> newValueChangeMap) {
        try {
            Map<Object, Object> configInfo = ConfigParserHandler.getInstance().parseConfig(configContent, this.bootstrapConfigProperties.getConfigFileType());
            if (CollectionUtil.isNotEmpty(newValueChangeMap)) {
                Optional.ofNullable(configInfo).ifPresent(each -> each.putAll(newValueChangeMap));
            }
            BootstrapConfigProperties binderCoreProperties = this.bootstrapConfigPropertiesBinderAdapt.bootstrapCorePropertiesBinder(configInfo, this.bootstrapConfigProperties);
            this.publishDynamicThreadPoolEvent(binderCoreProperties);
        }
        catch (Exception ex) {
            log.error("Hippo4j config mode dynamic refresh failed.", (Throwable)ex);
        }
    }

    private void publishDynamicThreadPoolEvent(BootstrapConfigProperties configProperties) {
        ApplicationContextHolder.getInstance().publishEvent((ApplicationEvent)new Hippo4jConfigDynamicRefreshEvent(this, configProperties));
    }

    public void afterPropertiesSet() {
        try {
            this.initRegisterListener();
        }
        catch (Exception ex) {
            log.error("Hippo4j failed to initialize register listener.", (Throwable)ex);
        }
    }

    public void run(ApplicationArguments args) {
        try {
            this.publishDynamicThreadPoolEvent(this.bootstrapConfigProperties);
        }
        catch (Exception ex) {
            log.error("Hippo4j failed to initialize update configuration.", (Throwable)ex);
        }
    }
}

