/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.refresher;

import cn.hippo4j.config.springboot.starter.refresher.AbstractConfigThreadPoolDynamicRefresh;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.cloud.bootstrap.config.BootstrapPropertySource;
import org.springframework.cloud.consul.config.ConsulPropertySource;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.AbstractEnvironment;

public class ConsulRefresherHandler
extends AbstractConfigThreadPoolDynamicRefresh {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsulRefresherHandler.class);

    @EventListener(value={EnvironmentChangeEvent.class})
    public void refreshed(EnvironmentChangeEvent event) {
        Map<String, Object> configInfo = this.extractLatestConfigInfo(event);
        this.dynamicRefresh("", configInfo);
    }

    private Map<String, Object> extractLatestConfigInfo(EnvironmentChangeEvent event) {
        AbstractEnvironment environment = (AbstractEnvironment)((AnnotationConfigServletWebServerApplicationContext)event.getSource()).getEnvironment();
        String activeProfile = Optional.ofNullable(environment.getActiveProfiles().length > 0 ? environment.getActiveProfiles()[0] : null).orElseGet(() -> String.valueOf(this.getApplicationConfigDefaultContext(environment)));
        List bootstrapPropertySourceList = environment.getPropertySources().stream().filter(propertySource -> propertySource instanceof BootstrapPropertySource).map(propertySource -> (BootstrapPropertySource)propertySource).collect(Collectors.toList());
        Optional<BootstrapPropertySource> bootstrapPropertySource = bootstrapPropertySourceList.stream().filter(source -> source.getName().contains(activeProfile) && source.getPropertyNames().length != 0).findFirst();
        HashMap<String, Object> configInfo = new HashMap<String, Object>(64);
        if (bootstrapPropertySource.isPresent()) {
            String[] propertyNames;
            ConsulPropertySource consulPropertySource = (ConsulPropertySource)bootstrapPropertySource.get().getDelegate();
            for (String propertyName : propertyNames = consulPropertySource.getPropertyNames()) {
                configInfo.put(propertyName, consulPropertySource.getProperty(propertyName));
            }
        }
        return configInfo;
    }

    private CharSequence getApplicationConfigDefaultContext(AbstractEnvironment environment) {
        return environment.getPropertySources().stream().filter(propertySource -> propertySource instanceof OriginTrackedMapPropertySource).map(propertySource -> (CharSequence)((Map)propertySource.getSource()).get("spring.cloud.consul.config.default-context")).findFirst().orElse("");
    }

    @Override
    protected void initRegisterListener() {
    }
}

