/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.refresher;

import cn.hippo4j.config.springboot.starter.refresher.AbstractConfigThreadPoolDynamicRefresh;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.api.core.ConfigKVFile;
import com.tencent.polaris.configuration.api.core.ConfigPropertyChangeInfo;
import java.util.HashMap;
import java.util.Objects;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;

public class PolarisRefresherHandler
extends AbstractConfigThreadPoolDynamicRefresh {
    private final ConfigFileService configFileService;
    private static final String POLARIS_NAMESPACE = "${spring.dynamic.thread-pool.polaris.namespace:dev}";
    private static final String POLARIS_FILE_GROUP = "${spring.dynamic.thread-pool.polaris.file.group:dynamic}";
    private static final String POLARIS_FILE_NAME = "${spring.dynamic.thread-pool.polaris.file.name:root/bootstrap.yaml}";
    private static final String POLARIS_FILE_TYPE = "${spring.dynamic.thread-pool.polaris.file.type:properties}";
    @Value(value="${spring.dynamic.thread-pool.polaris.namespace:dev}")
    private String namespace;
    @Value(value="${spring.dynamic.thread-pool.polaris.file.group:dynamic}")
    private String fileGroup;
    @Value(value="${spring.dynamic.thread-pool.polaris.file.name:root/bootstrap.yaml}")
    private String fileName;

    @Override
    public void initRegisterListener() {
        ConfigKVFile configFile = this.getConfigKVFile();
        configFile.addChangeListener(event -> {
            String content = configFile.getContent();
            HashMap<String, Object> newChangeValueMap = new HashMap<String, Object>();
            for (String key : event.changedKeys()) {
                ConfigPropertyChangeInfo changeInfo = event.getChangeInfo(key);
                newChangeValueMap.put(key, changeInfo.getNewValue());
            }
            this.dynamicRefresh(content, newChangeValueMap);
        });
    }

    private ConfigKVFile getConfigKVFile() {
        return Objects.equals(POLARIS_FILE_TYPE, "yaml") ? this.configFileService.getConfigYamlFile(this.namespace, this.fileGroup, this.fileName) : this.configFileService.getConfigPropertiesFile(this.namespace, this.fileGroup, this.fileName);
    }

    @Generated
    public PolarisRefresherHandler(ConfigFileService configFileService) {
        this.configFileService = configFileService;
    }
}

