/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.refresher;

import cn.hippo4j.config.springboot.starter.refresher.AbstractConfigThreadPoolDynamicRefresh;
import cn.hippo4j.message.service.GlobalNotifyAlarmManage;
import cn.hippo4j.message.service.ThreadPoolNotifyAlarm;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.WatchedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRefresherHandler
extends AbstractConfigThreadPoolDynamicRefresh {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperRefresherHandler.class);
    static final String ZK_CONNECT_STR = "zk-connect-str";
    static final String ROOT_NODE = "root-node";
    static final String CONFIG_VERSION = "config-version";
    static final String NODE = "node";
    private CuratorFramework curatorFramework;

    @Override
    public void initRegisterListener() {
        Map<String, String> zkConfigs = this.bootstrapConfigProperties.getZookeeper();
        this.curatorFramework = CuratorFrameworkFactory.newClient((String)zkConfigs.get(ZK_CONNECT_STR), (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        String nodePath = ZKPaths.makePath((String)ZKPaths.makePath((String)zkConfigs.get(ROOT_NODE), (String)zkConfigs.get(CONFIG_VERSION)), (String)zkConfigs.get(NODE));
        ConnectionStateListener connectionStateListener = (client, newState) -> {
            if (newState == ConnectionState.CONNECTED) {
                this.loadNode(nodePath);
            } else if (newState == ConnectionState.RECONNECTED) {
                this.loadNode(nodePath);
            }
        };
        CuratorListener curatorListener = (client, curatorEvent) -> {
            WatchedEvent watchedEvent = curatorEvent.getWatchedEvent();
            if (null != watchedEvent) {
                switch (watchedEvent.getType()) {
                    case NodeChildrenChanged: 
                    case NodeDataChanged: {
                        this.loadNode(nodePath);
                        break;
                    }
                }
            }
        };
        this.curatorFramework.getConnectionStateListenable().addListener((Object)connectionStateListener);
        this.curatorFramework.getCuratorListenable().addListener((Object)curatorListener);
        this.curatorFramework.start();
    }

    public void loadNode(String nodePath) {
        String content = this.nodePathResolver(nodePath);
        if (content != null) {
            this.dynamicRefresh(content);
            this.registerNotifyAlarmManage();
        }
    }

    private String nodePathResolver(String nodePath) {
        try {
            GetChildrenBuilder childrenBuilder = this.curatorFramework.getChildren();
            List children = (List)((BackgroundPathable)childrenBuilder.watched()).forPath(nodePath);
            StringBuilder content = new StringBuilder();
            children.forEach(c -> {
                String n = ZKPaths.makePath((String)nodePath, (String)c);
                String nodeName = ZKPaths.getNodeFromPath((String)n);
                GetDataBuilder data = this.curatorFramework.getData();
                String value = "";
                try {
                    value = new String((byte[])((BackgroundPathable)data.watched()).forPath(n), StandardCharsets.UTF_8);
                }
                catch (Exception ex) {
                    log.error("Load zookeeper node error", (Throwable)ex);
                }
                content.append(nodeName).append("=").append(value).append("\n");
            });
            return content.toString();
        }
        catch (Exception ex) {
            log.error("Load zookeeper node error, nodePath is: {}", (Object)nodePath, (Object)ex);
            return null;
        }
    }

    public void registerNotifyAlarmManage() {
        this.bootstrapConfigProperties.getExecutors().forEach(executorProperties -> {
            ThreadPoolNotifyAlarm threadPoolNotifyAlarm = new ThreadPoolNotifyAlarm(executorProperties.getAlarm(), executorProperties.getCapacityAlarm(), executorProperties.getActiveAlarm());
            threadPoolNotifyAlarm.setInterval(executorProperties.getNotify().getInterval());
            threadPoolNotifyAlarm.setReceives(executorProperties.getNotify().getReceives());
            GlobalNotifyAlarmManage.put((String)executorProperties.getThreadPoolId(), (ThreadPoolNotifyAlarm)threadPoolNotifyAlarm);
        });
    }
}

