/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.refresher.event;

import cn.hippo4j.adapter.base.ThreadPoolAdapter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterParameter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterState;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.toolkit.BeanUtil;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.config.springboot.starter.config.AdapterExecutorProperties;
import cn.hippo4j.config.springboot.starter.refresher.event.AbstractRefreshListener;
import cn.hippo4j.config.springboot.starter.refresher.event.Hippo4jConfigDynamicRefreshEvent;
import cn.hippo4j.config.springboot.starter.support.DynamicThreadPoolAdapterRegister;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=3)
public class AdapterExecutorsRefreshListener
extends AbstractRefreshListener<AdapterExecutorProperties> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdapterExecutorsRefreshListener.class);
    private final DynamicThreadPoolAdapterRegister dynamicThreadPoolAdapterRegister;

    @Override
    public String getNodes(AdapterExecutorProperties properties) {
        return properties.getNodes();
    }

    public void onApplicationEvent(Hippo4jConfigDynamicRefreshEvent event) {
        Map threadPoolAdapterMap = ApplicationContextHolder.getBeansOfType(ThreadPoolAdapter.class);
        List<AdapterExecutorProperties> adapterExecutors = event.getBootstrapConfigProperties().getAdapterExecutors();
        if (CollectionUtil.isEmpty(adapterExecutors) || CollectionUtil.isEmpty((Map)threadPoolAdapterMap)) {
            return;
        }
        for (AdapterExecutorProperties each : adapterExecutors) {
            String buildKey = each.getMark() + "_" + each.getThreadPoolKey();
            AdapterExecutorProperties adapterExecutorProperties = this.dynamicThreadPoolAdapterRegister.discoverAdapterExecutorAndGet(buildKey);
            if (adapterExecutorProperties == null || !adapterExecutorProperties.getEnable().booleanValue() || !this.match(adapterExecutorProperties)) continue;
            threadPoolAdapterMap.forEach((key, val) -> {
                ThreadPoolAdapterState threadPoolState;
                if (!(!Objects.equals(val.mark(), each.getMark()) || Objects.equals((threadPoolState = val.getThreadPoolState(each.getThreadPoolKey())).getCoreSize(), each.getCorePoolSize()) && Objects.equals(threadPoolState.getMaximumSize(), each.getMaximumPoolSize()))) {
                    val.updateThreadPool((ThreadPoolAdapterParameter)BeanUtil.convert((Object)each, ThreadPoolAdapterParameter.class));
                    DynamicThreadPoolAdapterRegister.ADAPTER_EXECUTORS_MAP.put(buildKey, each);
                }
            });
        }
    }

    @Generated
    public AdapterExecutorsRefreshListener(DynamicThreadPoolAdapterRegister dynamicThreadPoolAdapterRegister) {
        this.dynamicThreadPoolAdapterRegister = dynamicThreadPoolAdapterRegister;
    }
}

