/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.refresher.event;

import cn.hippo4j.common.api.NotifyRequest;
import cn.hippo4j.common.api.ThreadPoolConfigChange;
import cn.hippo4j.common.executor.support.BlockingQueueTypeEnum;
import cn.hippo4j.common.executor.support.RejectedPolicyTypeEnum;
import cn.hippo4j.common.executor.support.ResizableCapacityLinkedBlockingQueue;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.toolkit.ThreadPoolExecutorUtil;
import cn.hippo4j.config.springboot.starter.config.BootstrapConfigProperties;
import cn.hippo4j.config.springboot.starter.config.ExecutorProperties;
import cn.hippo4j.config.springboot.starter.notify.ConfigModeNotifyConfigBuilder;
import cn.hippo4j.config.springboot.starter.refresher.event.AbstractRefreshListener;
import cn.hippo4j.config.springboot.starter.refresher.event.Hippo4jConfigDynamicRefreshEvent;
import cn.hippo4j.config.springboot.starter.support.GlobalCoreThreadPoolManage;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.request.ChangeParameterNotifyRequest;
import cn.hippo4j.message.service.GlobalNotifyAlarmManage;
import cn.hippo4j.message.service.Hippo4jBaseSendMessageService;
import cn.hippo4j.message.service.ThreadPoolNotifyAlarm;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=2)
public class DynamicThreadPoolRefreshListener
extends AbstractRefreshListener<ExecutorProperties> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolRefreshListener.class);
    private final ThreadPoolConfigChange threadPoolConfigChange;
    private final ConfigModeNotifyConfigBuilder configModeNotifyConfigBuilder;
    private final Hippo4jBaseSendMessageService hippo4jBaseSendMessageService;

    @Override
    public String getNodes(ExecutorProperties properties) {
        return properties.getNodes();
    }

    public void onApplicationEvent(Hippo4jConfigDynamicRefreshEvent event) {
        BootstrapConfigProperties bindableConfigProperties = event.getBootstrapConfigProperties();
        List<ExecutorProperties> executors = bindableConfigProperties.getExecutors();
        for (ExecutorProperties properties : executors) {
            String threadPoolId = properties.getThreadPoolId();
            if (!this.match(properties)) continue;
            this.checkNotifyConsistencyAndReplace(properties);
            if (!this.checkConsistency(threadPoolId, properties)) continue;
            this.dynamicRefreshPool(threadPoolId, properties);
            ExecutorProperties beforeProperties = GlobalCoreThreadPoolManage.getProperties(properties.getThreadPoolId());
            GlobalCoreThreadPoolManage.refresh(threadPoolId, this.failDefaultExecutorProperties(beforeProperties, properties));
            ChangeParameterNotifyRequest changeRequest = this.buildChangeRequest(beforeProperties, properties);
            log.info("[{}] Dynamic thread pool change parameter.\n    corePoolSize: {}\n    maximumPoolSize: {}\n    capacity: {}\n    keepAliveTime: {}\n    executeTimeOut: {}\n    rejectedType: {}\n    allowCoreThreadTimeOut: {}", new Object[]{threadPoolId, String.format("%s => %s", beforeProperties.getCorePoolSize(), changeRequest.getNowCorePoolSize()), String.format("%s => %s", beforeProperties.getMaximumPoolSize(), changeRequest.getNowMaximumPoolSize()), String.format("%s => %s", beforeProperties.getQueueCapacity(), changeRequest.getNowQueueCapacity()), String.format("%s => %s", beforeProperties.getKeepAliveTime(), changeRequest.getNowKeepAliveTime()), String.format("%s => %s", beforeProperties.getExecuteTimeOut(), changeRequest.getNowExecuteTimeOut()), String.format("%s => %s", beforeProperties.getRejectedHandler(), changeRequest.getNowRejectedName()), String.format("%s => %s", beforeProperties.getAllowCoreThreadTimeOut(), changeRequest.getNowAllowsCoreThreadTimeOut())});
            try {
                this.threadPoolConfigChange.sendPoolConfigChange((NotifyRequest)changeRequest);
            }
            catch (Throwable ex) {
                log.error("Failed to send Chang smart application listener notice. Message: {}", (Object)ex.getMessage());
            }
        }
    }

    private ExecutorProperties failDefaultExecutorProperties(ExecutorProperties beforeProperties, ExecutorProperties properties) {
        return ExecutorProperties.builder().corePoolSize(Optional.ofNullable(properties.getCorePoolSize()).orElse(beforeProperties.getCorePoolSize())).maximumPoolSize(Optional.ofNullable(properties.getMaximumPoolSize()).orElse(beforeProperties.getMaximumPoolSize())).blockingQueue(properties.getBlockingQueue()).queueCapacity(Optional.ofNullable(properties.getQueueCapacity()).orElse(beforeProperties.getQueueCapacity())).keepAliveTime(Optional.ofNullable(properties.getKeepAliveTime()).orElse(beforeProperties.getKeepAliveTime())).executeTimeOut(Optional.ofNullable(properties.getExecuteTimeOut()).orElse(beforeProperties.getExecuteTimeOut())).rejectedHandler(Optional.ofNullable(properties.getRejectedHandler()).orElse(beforeProperties.getRejectedHandler())).allowCoreThreadTimeOut(Optional.ofNullable(properties.getAllowCoreThreadTimeOut()).orElse(beforeProperties.getAllowCoreThreadTimeOut())).threadPoolId(beforeProperties.getThreadPoolId()).build();
    }

    private ChangeParameterNotifyRequest buildChangeRequest(ExecutorProperties beforeProperties, ExecutorProperties properties) {
        ChangeParameterNotifyRequest changeParameterNotifyRequest = ChangeParameterNotifyRequest.builder().beforeCorePoolSize(beforeProperties.getCorePoolSize()).beforeMaximumPoolSize(beforeProperties.getMaximumPoolSize()).beforeAllowsCoreThreadTimeOut(beforeProperties.getAllowCoreThreadTimeOut()).beforeKeepAliveTime(beforeProperties.getKeepAliveTime()).beforeQueueCapacity(beforeProperties.getQueueCapacity()).beforeRejectedName(beforeProperties.getRejectedHandler()).beforeExecuteTimeOut(beforeProperties.getExecuteTimeOut()).blockingQueueName(properties.getBlockingQueue()).nowCorePoolSize(Optional.ofNullable(properties.getCorePoolSize()).orElse(beforeProperties.getCorePoolSize())).nowMaximumPoolSize(Optional.ofNullable(properties.getMaximumPoolSize()).orElse(beforeProperties.getMaximumPoolSize())).nowAllowsCoreThreadTimeOut(Optional.ofNullable(properties.getAllowCoreThreadTimeOut()).orElse(beforeProperties.getAllowCoreThreadTimeOut())).nowKeepAliveTime(Optional.ofNullable(properties.getKeepAliveTime()).orElse(beforeProperties.getKeepAliveTime())).nowQueueCapacity(Optional.ofNullable(properties.getQueueCapacity()).orElse(beforeProperties.getQueueCapacity())).nowRejectedName(Optional.ofNullable(properties.getRejectedHandler()).orElse(beforeProperties.getRejectedHandler())).nowExecuteTimeOut(Optional.ofNullable(properties.getExecuteTimeOut()).orElse(beforeProperties.getExecuteTimeOut())).build();
        changeParameterNotifyRequest.setThreadPoolId(beforeProperties.getThreadPoolId());
        return changeParameterNotifyRequest;
    }

    private void checkNotifyConsistencyAndReplace(ExecutorProperties executorProperties) {
        ThreadPoolNotifyAlarm threadPoolNotifyAlarm;
        boolean checkNotifyConfig = false;
        boolean checkNotifyAlarm = false;
        ArrayList<String> changeKeys = new ArrayList<String>();
        Map<String, List<NotifyConfigDTO>> newDynamicThreadPoolNotifyMap = this.configModeNotifyConfigBuilder.buildSingleNotifyConfig(executorProperties);
        Map notifyConfigs = this.hippo4jBaseSendMessageService.getNotifyConfigs();
        if (CollectionUtil.isNotEmpty((Map)notifyConfigs)) {
            block0: for (Map.Entry<String, List<NotifyConfigDTO>> each : newDynamicThreadPoolNotifyMap.entrySet()) {
                if (checkNotifyConfig) break;
                List notifyConfigDTOS = (List)notifyConfigs.get(each.getKey());
                for (NotifyConfigDTO notifyConfig : each.getValue()) {
                    if (notifyConfigDTOS.contains(notifyConfig)) continue;
                    checkNotifyConfig = true;
                    changeKeys.add(each.getKey());
                    continue block0;
                }
            }
        }
        if (checkNotifyConfig) {
            this.configModeNotifyConfigBuilder.initCacheAndLock(newDynamicThreadPoolNotifyMap);
            this.hippo4jBaseSendMessageService.putPlatform(newDynamicThreadPoolNotifyMap);
        }
        if ((threadPoolNotifyAlarm = GlobalNotifyAlarmManage.get((String)executorProperties.getThreadPoolId())) != null) {
            Boolean isAlarm = executorProperties.getAlarm();
            Integer activeAlarm = executorProperties.getActiveAlarm();
            Integer capacityAlarm = executorProperties.getCapacityAlarm();
            if (isAlarm != null && isAlarm != threadPoolNotifyAlarm.getAlarm() || activeAlarm != null && activeAlarm != threadPoolNotifyAlarm.getActiveAlarm() || capacityAlarm != null && capacityAlarm != threadPoolNotifyAlarm.getCapacityAlarm()) {
                checkNotifyAlarm = true;
                threadPoolNotifyAlarm.setAlarm(Optional.ofNullable(isAlarm).orElse(threadPoolNotifyAlarm.getAlarm()));
                threadPoolNotifyAlarm.setActiveAlarm(Optional.ofNullable(activeAlarm).orElse(threadPoolNotifyAlarm.getActiveAlarm()));
                threadPoolNotifyAlarm.setCapacityAlarm(Optional.ofNullable(capacityAlarm).orElse(threadPoolNotifyAlarm.getCapacityAlarm()));
            }
        }
        if (checkNotifyConfig || checkNotifyAlarm) {
            log.info("[{}] Dynamic thread pool notification property changes.", (Object)executorProperties.getThreadPoolId());
        }
    }

    private boolean checkConsistency(String threadPoolId, ExecutorProperties properties) {
        ExecutorProperties beforeProperties = GlobalCoreThreadPoolManage.getProperties(properties.getThreadPoolId());
        ThreadPoolExecutor executor = GlobalThreadPoolManage.getExecutor((String)threadPoolId);
        if (executor == null) {
            return false;
        }
        boolean result = properties.getCorePoolSize() != null && !Objects.equals(beforeProperties.getCorePoolSize(), properties.getCorePoolSize()) || properties.getMaximumPoolSize() != null && !Objects.equals(beforeProperties.getMaximumPoolSize(), properties.getMaximumPoolSize()) || properties.getAllowCoreThreadTimeOut() != null && !Objects.equals(beforeProperties.getAllowCoreThreadTimeOut(), properties.getAllowCoreThreadTimeOut()) || properties.getExecuteTimeOut() != null && !Objects.equals(beforeProperties.getExecuteTimeOut(), properties.getExecuteTimeOut()) || properties.getKeepAliveTime() != null && !Objects.equals(beforeProperties.getKeepAliveTime(), properties.getKeepAliveTime()) || properties.getRejectedHandler() != null && !Objects.equals(beforeProperties.getRejectedHandler(), properties.getRejectedHandler()) || properties.getQueueCapacity() != null && !Objects.equals(beforeProperties.getQueueCapacity(), properties.getQueueCapacity()) && Objects.equals(BlockingQueueTypeEnum.RESIZABLE_LINKED_BLOCKING_QUEUE.getName(), executor.getQueue().getClass().getSimpleName());
        return result;
    }

    private void dynamicRefreshPool(String threadPoolId, ExecutorProperties properties) {
        ExecutorProperties beforeProperties = GlobalCoreThreadPoolManage.getProperties(properties.getThreadPoolId());
        ThreadPoolExecutor executor = GlobalThreadPoolManage.getExecutorService((String)threadPoolId).getExecutor();
        if (properties.getMaximumPoolSize() != null && properties.getCorePoolSize() != null) {
            ThreadPoolExecutorUtil.safeSetPoolSize((ThreadPoolExecutor)executor, (int)properties.getCorePoolSize(), (int)properties.getMaximumPoolSize());
        } else {
            if (properties.getMaximumPoolSize() != null) {
                executor.setMaximumPoolSize(properties.getMaximumPoolSize());
            }
            if (properties.getCorePoolSize() != null) {
                executor.setCorePoolSize(properties.getCorePoolSize());
            }
        }
        if (properties.getAllowCoreThreadTimeOut() != null && !Objects.equals(beforeProperties.getAllowCoreThreadTimeOut(), properties.getAllowCoreThreadTimeOut())) {
            executor.allowCoreThreadTimeOut(properties.getAllowCoreThreadTimeOut());
        }
        if (properties.getExecuteTimeOut() != null && !Objects.equals(beforeProperties.getExecuteTimeOut(), properties.getExecuteTimeOut()) && executor instanceof DynamicThreadPoolExecutor) {
            ((DynamicThreadPoolExecutor)executor).setExecuteTimeOut(properties.getExecuteTimeOut());
        }
        if (properties.getRejectedHandler() != null && !Objects.equals(beforeProperties.getRejectedHandler(), properties.getRejectedHandler())) {
            RejectedExecutionHandler rejectedExecutionHandler = RejectedPolicyTypeEnum.createPolicy((String)properties.getRejectedHandler());
            executor.setRejectedExecutionHandler(rejectedExecutionHandler);
        }
        if (properties.getKeepAliveTime() != null && !Objects.equals(beforeProperties.getKeepAliveTime(), properties.getKeepAliveTime())) {
            executor.setKeepAliveTime(properties.getKeepAliveTime(), TimeUnit.SECONDS);
        }
        if (properties.getQueueCapacity() != null && !Objects.equals(beforeProperties.getQueueCapacity(), properties.getQueueCapacity()) && Objects.equals(BlockingQueueTypeEnum.RESIZABLE_LINKED_BLOCKING_QUEUE.getName(), executor.getQueue().getClass().getSimpleName())) {
            if (executor.getQueue() instanceof ResizableCapacityLinkedBlockingQueue) {
                ResizableCapacityLinkedBlockingQueue queue = (ResizableCapacityLinkedBlockingQueue)executor.getQueue();
                queue.setCapacity(properties.getQueueCapacity().intValue());
            } else {
                log.warn("The queue length cannot be modified. Queue type mismatch. Current queue type: {}", (Object)executor.getQueue().getClass().getSimpleName());
            }
        }
    }

    @Generated
    public DynamicThreadPoolRefreshListener(ThreadPoolConfigChange threadPoolConfigChange, ConfigModeNotifyConfigBuilder configModeNotifyConfigBuilder, Hippo4jBaseSendMessageService hippo4jBaseSendMessageService) {
        this.threadPoolConfigChange = threadPoolConfigChange;
        this.configModeNotifyConfigBuilder = configModeNotifyConfigBuilder;
        this.hippo4jBaseSendMessageService = hippo4jBaseSendMessageService;
    }
}

