/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.refresher.event;

import cn.hippo4j.adapter.web.WebThreadPoolHandlerChoose;
import cn.hippo4j.adapter.web.WebThreadPoolService;
import cn.hippo4j.common.api.NotifyRequest;
import cn.hippo4j.common.api.ThreadPoolConfigChange;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.config.springboot.starter.config.BootstrapConfigProperties;
import cn.hippo4j.config.springboot.starter.config.WebExecutorProperties;
import cn.hippo4j.config.springboot.starter.refresher.event.AbstractRefreshListener;
import cn.hippo4j.config.springboot.starter.refresher.event.Hippo4jConfigDynamicRefreshEvent;
import cn.hippo4j.message.request.WebChangeParameterNotifyRequest;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=0)
public class WebExecutorRefreshListener
extends AbstractRefreshListener<WebExecutorProperties> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebExecutorRefreshListener.class);
    private final ThreadPoolConfigChange configChange;

    public WebExecutorRefreshListener(ThreadPoolConfigChange configChange) {
        this.configChange = configChange;
    }

    @Override
    public String getNodes(WebExecutorProperties properties) {
        return properties.getNodes();
    }

    public void onApplicationEvent(Hippo4jConfigDynamicRefreshEvent threadPoolDynamicRefreshEvent) {
        BootstrapConfigProperties bindableCoreProperties = threadPoolDynamicRefreshEvent.getBootstrapConfigProperties();
        if (bindableCoreProperties.getWeb() == null) {
            return;
        }
        try {
            ThreadPoolParameterInfo nowParameter = this.buildWebPoolParameter(bindableCoreProperties);
            if (nowParameter != null) {
                WebThreadPoolHandlerChoose webThreadPoolHandlerChoose = (WebThreadPoolHandlerChoose)ApplicationContextHolder.getBean(WebThreadPoolHandlerChoose.class);
                WebThreadPoolService webThreadPoolService = webThreadPoolHandlerChoose.choose();
                ThreadPoolParameter beforeParameter = webThreadPoolService.getWebThreadPoolParameter();
                if (nowParameter.getCoreSize() == null) {
                    nowParameter.setCoreSize(beforeParameter.getCoreSize());
                }
                if (nowParameter.getMaxSize() == null) {
                    nowParameter.setMaxSize(beforeParameter.getMaxSize());
                }
                if (nowParameter.getKeepAliveTime() == null) {
                    nowParameter.setKeepAliveTime(beforeParameter.getKeepAliveTime());
                }
                if (!(Objects.equals(beforeParameter.getCoreSize(), nowParameter.getCoreSize()) && Objects.equals(beforeParameter.getMaxSize(), nowParameter.getMaxSize()) && Objects.equals(beforeParameter.getKeepAliveTime(), nowParameter.getKeepAliveTime()))) {
                    webThreadPoolService.updateWebThreadPool(nowParameter);
                    this.configChange.sendPoolConfigChange((NotifyRequest)this.buildChangeRequest(beforeParameter, (ThreadPoolParameter)nowParameter, webThreadPoolService));
                }
            }
        }
        catch (Exception ex) {
            log.error("Failed to modify web thread pool.", (Throwable)ex);
        }
    }

    private WebChangeParameterNotifyRequest buildChangeRequest(ThreadPoolParameter before, ThreadPoolParameter now, WebThreadPoolService webThreadPoolService) {
        WebChangeParameterNotifyRequest changeNotifyRequest = WebChangeParameterNotifyRequest.builder().beforeCorePoolSize(before.getCoreSize()).nowCorePoolSize(now.getCoreSize()).beforeMaximumPoolSize(before.getMaxSize()).nowMaximumPoolSize(now.getMaxSize()).beforeKeepAliveTime(before.getKeepAliveTime()).nowKeepAliveTime(now.getKeepAliveTime()).build();
        changeNotifyRequest.setThreadPoolId(webThreadPoolService.getWebContainerType().getName());
        return changeNotifyRequest;
    }

    private ThreadPoolParameterInfo buildWebPoolParameter(BootstrapConfigProperties bindableCoreProperties) {
        ThreadPoolParameterInfo threadPoolParameterInfo = null;
        WebExecutorProperties webThreadPoolProperties = bindableCoreProperties.getWeb();
        if (webThreadPoolProperties != null && webThreadPoolProperties.getEnable().booleanValue() && this.match(webThreadPoolProperties)) {
            threadPoolParameterInfo = ThreadPoolParameterInfo.builder().coreSize(webThreadPoolProperties.getCorePoolSize()).maximumPoolSize(webThreadPoolProperties.getMaximumPoolSize()).keepAliveTime(webThreadPoolProperties.getKeepAliveTime()).build();
        }
        return threadPoolParameterInfo;
    }
}

