/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.support;

import cn.hippo4j.config.springboot.starter.config.AdapterExecutorProperties;
import cn.hippo4j.config.springboot.starter.config.BootstrapConfigProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class DynamicThreadPoolAdapterRegister
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolAdapterRegister.class);
    private final BootstrapConfigProperties bootstrapConfigProperties;
    public static final Map<String, AdapterExecutorProperties> ADAPTER_EXECUTORS_MAP = new ConcurrentHashMap<String, AdapterExecutorProperties>();

    public void afterPropertiesSet() throws Exception {
        this.discoverAdapterExecutor();
    }

    public AdapterExecutorProperties discoverAdapterExecutorAndGet(String mark) {
        List<AdapterExecutorProperties> adapterExecutors = this.bootstrapConfigProperties.getAdapterExecutors();
        for (AdapterExecutorProperties each : adapterExecutors) {
            String buildKey = each.getMark() + "_" + each.getThreadPoolKey();
            ADAPTER_EXECUTORS_MAP.putIfAbsent(buildKey, each);
        }
        return ADAPTER_EXECUTORS_MAP.get(mark);
    }

    public void discoverAdapterExecutor() {
        Optional<List<AdapterExecutorProperties>> adapterExecutorProperties = Optional.ofNullable(this.bootstrapConfigProperties.getAdapterExecutors());
        adapterExecutorProperties.ifPresent(props -> {
            for (AdapterExecutorProperties each : props) {
                String buildKey = each.getMark() + "_" + each.getThreadPoolKey();
                ADAPTER_EXECUTORS_MAP.putIfAbsent(buildKey, each);
            }
        });
    }

    @Generated
    public DynamicThreadPoolAdapterRegister(BootstrapConfigProperties bootstrapConfigProperties) {
        this.bootstrapConfigProperties = bootstrapConfigProperties;
    }
}

