/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.support;

import cn.hippo4j.common.api.ExecutorNotifyProperties;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.executor.support.BlockingQueueTypeEnum;
import cn.hippo4j.common.executor.support.RejectedPolicyTypeEnum;
import cn.hippo4j.common.toolkit.ReflectUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.common.toolkit.ThreadPoolExecutorUtil;
import cn.hippo4j.config.springboot.starter.config.BootstrapConfigProperties;
import cn.hippo4j.config.springboot.starter.config.ExecutorProperties;
import cn.hippo4j.config.springboot.starter.support.GlobalCoreThreadPoolManage;
import cn.hippo4j.core.executor.DynamicThreadPool;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.adpter.DynamicThreadPoolAdapterChoose;
import cn.hippo4j.core.toolkit.DynamicThreadPoolAnnotationUtil;
import cn.hippo4j.message.service.GlobalNotifyAlarmManage;
import cn.hippo4j.message.service.ThreadPoolNotifyAlarm;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public final class DynamicThreadPoolPostProcessor
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolPostProcessor.class);
    private final BootstrapConfigProperties configProperties;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DynamicThreadPoolExecutor || DynamicThreadPoolAdapterChoose.match((Object)bean)) {
            try {
                DynamicThreadPool dynamicThreadPool = (DynamicThreadPool)ApplicationContextHolder.findAnnotationOnBean((String)beanName, DynamicThreadPool.class);
                if (Objects.isNull(dynamicThreadPool) && Objects.isNull(dynamicThreadPool = (DynamicThreadPool)DynamicThreadPoolAnnotationUtil.findAnnotationOnBean((String)beanName, DynamicThreadPool.class))) {
                    return bean;
                }
            }
            catch (Exception ex) {
                log.error("Failed to create dynamic thread pool in annotation mode.", (Throwable)ex);
                return bean;
            }
            DynamicThreadPoolExecutor dynamicThreadPoolExecutor = DynamicThreadPoolAdapterChoose.unwrap((Object)bean);
            if (dynamicThreadPoolExecutor == null) {
                dynamicThreadPoolExecutor = (DynamicThreadPoolExecutor)bean;
            }
            DynamicThreadPoolWrapper wrap = new DynamicThreadPoolWrapper(dynamicThreadPoolExecutor.getThreadPoolId(), (ThreadPoolExecutor)dynamicThreadPoolExecutor);
            ThreadPoolExecutor remoteThreadPoolExecutor = this.fillPoolAndRegister(wrap);
            DynamicThreadPoolAdapterChoose.replace((Object)bean, (Executor)remoteThreadPoolExecutor);
            return DynamicThreadPoolAdapterChoose.match((Object)bean) ? bean : remoteThreadPoolExecutor;
        }
        if (bean instanceof DynamicThreadPoolWrapper) {
            DynamicThreadPoolWrapper wrap = (DynamicThreadPoolWrapper)bean;
            this.fillPoolAndRegister(wrap);
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPoolExecutor fillPoolAndRegister(DynamicThreadPoolWrapper dynamicThreadPoolWrapper) {
        String threadPoolId = dynamicThreadPoolWrapper.getThreadPoolId();
        ThreadPoolExecutor executor = dynamicThreadPoolWrapper.getExecutor();
        ExecutorProperties executorProperties = null;
        if (this.configProperties.getExecutors() != null) {
            executorProperties = this.configProperties.getExecutors().stream().filter(each -> Objects.equals(threadPoolId, each.getThreadPoolId())).findFirst().orElseThrow(() -> new RuntimeException("The thread pool id does not exist in the configuration."));
            try {
                executorProperties = this.buildActualExecutorProperties(executorProperties);
                this.threadPoolParamReplace(executor, executorProperties);
            }
            catch (Exception ex) {
                log.error("Failed to initialize thread pool configuration.", (Throwable)ex);
            }
            finally {
                dynamicThreadPoolWrapper.setInitFlag(Boolean.TRUE.booleanValue());
            }
            ThreadPoolNotifyAlarm threadPoolNotifyAlarm = this.buildThreadPoolNotifyAlarm(executorProperties);
            GlobalNotifyAlarmManage.put((String)threadPoolId, (ThreadPoolNotifyAlarm)threadPoolNotifyAlarm);
        }
        GlobalThreadPoolManage.registerPool((String)dynamicThreadPoolWrapper.getThreadPoolId(), (DynamicThreadPoolWrapper)dynamicThreadPoolWrapper);
        GlobalCoreThreadPoolManage.register(threadPoolId, executorProperties == null ? this.buildDefaultExecutorProperties(threadPoolId, executor) : executorProperties);
        return executor;
    }

    private ExecutorProperties buildActualExecutorProperties(ExecutorProperties executorProperties) {
        return Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(each -> this.buildExecutorProperties(executorProperties)).orElse(executorProperties);
    }

    private ExecutorProperties buildDefaultExecutorProperties(String threadPoolId, ThreadPoolExecutor executor) {
        ExecutorProperties executorProperties = new ExecutorProperties();
        BlockingQueue<Runnable> blockingQueue = executor.getQueue();
        int queueSize = blockingQueue.size();
        String queueType = blockingQueue.getClass().getSimpleName();
        int remainingCapacity = blockingQueue.remainingCapacity();
        int queueCapacity = queueSize + remainingCapacity;
        executorProperties.setCorePoolSize(executor.getCorePoolSize()).setMaximumPoolSize(executor.getMaximumPoolSize()).setAllowCoreThreadTimeOut(executor.allowsCoreThreadTimeOut()).setKeepAliveTime(executor.getKeepAliveTime(TimeUnit.SECONDS)).setBlockingQueue(queueType).setExecuteTimeOut(10000L).setQueueCapacity(queueCapacity).setRejectedHandler(executor.getRejectedExecutionHandler().getClass().getSimpleName()).setThreadPoolId(threadPoolId);
        return executorProperties;
    }

    private void threadPoolParamReplace(ThreadPoolExecutor executor, ExecutorProperties executorProperties) {
        BlockingQueue workQueue = BlockingQueueTypeEnum.createBlockingQueue((String)executorProperties.getBlockingQueue(), (Integer)executorProperties.getQueueCapacity());
        ReflectUtil.setFieldValue((Object)executor, (String)"workQueue", (Object)workQueue);
        ThreadPoolExecutorUtil.safeSetPoolSize((ThreadPoolExecutor)executor, (int)executorProperties.getCorePoolSize(), (int)executorProperties.getMaximumPoolSize());
        executor.setKeepAliveTime(executorProperties.getKeepAliveTime(), TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(executorProperties.getAllowCoreThreadTimeOut());
        executor.setRejectedExecutionHandler(RejectedPolicyTypeEnum.createPolicy((String)executorProperties.getRejectedHandler()));
        if (executor instanceof DynamicThreadPoolExecutor) {
            Optional.ofNullable(executorProperties.getExecuteTimeOut()).ifPresent(executeTimeOut -> ((DynamicThreadPoolExecutor)executor).setExecuteTimeOut(executeTimeOut));
        }
    }

    private ExecutorProperties buildExecutorProperties(ExecutorProperties executorProperties) {
        return ExecutorProperties.builder().corePoolSize(Optional.ofNullable(executorProperties.getCorePoolSize()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getCorePoolSize).get())).maximumPoolSize(Optional.ofNullable(executorProperties.getMaximumPoolSize()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getMaximumPoolSize).get())).allowCoreThreadTimeOut(Optional.ofNullable(executorProperties.getAllowCoreThreadTimeOut()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getAllowCoreThreadTimeOut).get())).keepAliveTime(Optional.ofNullable(executorProperties.getKeepAliveTime()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getKeepAliveTime).get())).blockingQueue(Optional.ofNullable(executorProperties.getBlockingQueue()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getBlockingQueue).get())).executeTimeOut(Optional.ofNullable(executorProperties.getExecuteTimeOut()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getExecuteTimeOut).orElse(0L))).queueCapacity(Optional.ofNullable(executorProperties.getQueueCapacity()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getQueueCapacity).get())).rejectedHandler(Optional.ofNullable(executorProperties.getRejectedHandler()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getRejectedHandler).get())).threadNamePrefix(StringUtil.isBlank((CharSequence)executorProperties.getThreadNamePrefix()) ? executorProperties.getThreadPoolId() : executorProperties.getThreadNamePrefix()).threadPoolId(executorProperties.getThreadPoolId()).alarm(Optional.ofNullable(executorProperties.getAlarm()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getAlarm).orElse(null))).activeAlarm(Optional.ofNullable(executorProperties.getActiveAlarm()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getActiveAlarm).orElse(null))).capacityAlarm(Optional.ofNullable(executorProperties.getCapacityAlarm()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getCapacityAlarm).orElse(null))).notify(Optional.ofNullable(executorProperties.getNotify()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getNotify).orElse(null))).nodes(Optional.ofNullable(executorProperties.getNodes()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getNodes).orElse(null))).build();
    }

    private ThreadPoolNotifyAlarm buildThreadPoolNotifyAlarm(ExecutorProperties executorProperties) {
        ExecutorNotifyProperties notify = Optional.ofNullable(executorProperties).map(ExecutorProperties::getNotify).orElse(null);
        boolean isAlarm = Optional.ofNullable(executorProperties.getAlarm()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getAlarm).orElse(true));
        int activeAlarm = Optional.ofNullable(executorProperties.getActiveAlarm()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getActiveAlarm).orElse(80));
        int capacityAlarm = Optional.ofNullable(executorProperties.getCapacityAlarm()).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getCapacityAlarm).orElse(80));
        int interval = Optional.ofNullable(notify).map(ExecutorNotifyProperties::getInterval).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getNotify).map(ExecutorNotifyProperties::getInterval).orElse(5));
        String receive = Optional.ofNullable(notify).map(ExecutorNotifyProperties::getReceives).orElseGet(() -> Optional.ofNullable(this.configProperties.getDefaultExecutor()).map(ExecutorProperties::getNotify).map(ExecutorNotifyProperties::getReceives).orElse(""));
        ThreadPoolNotifyAlarm threadPoolNotifyAlarm = new ThreadPoolNotifyAlarm(Boolean.valueOf(isAlarm), Integer.valueOf(activeAlarm), Integer.valueOf(capacityAlarm));
        threadPoolNotifyAlarm.setInterval(Integer.valueOf(interval));
        threadPoolNotifyAlarm.setReceives(receive);
        return threadPoolNotifyAlarm;
    }

    @Generated
    public DynamicThreadPoolPostProcessor(BootstrapConfigProperties configProperties) {
        this.configProperties = configProperties;
    }
}

