/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.toolkit;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.core.toolkit.inet.InetUtils;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.springframework.core.env.ConfigurableEnvironment;

public class IdentifyUtil {
    private static String IDENTIFY;
    public static final String CLIENT_IDENTIFICATION_VALUE;

    public static synchronized String generate(ConfigurableEnvironment environment, InetUtils hippo4JInetUtils) {
        String identification;
        if (StrUtil.isNotBlank((CharSequence)IDENTIFY)) {
            return IDENTIFY;
        }
        String ip = hippo4JInetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
        String port = environment.getProperty("server.port", "8080");
        IDENTIFY = identification = StrUtil.builder((CharSequence[])new CharSequence[]{ip, ":", port, "_", CLIENT_IDENTIFICATION_VALUE}).toString();
        return identification;
    }

    public static String getIdentify() {
        while (StrUtil.isBlank((CharSequence)IDENTIFY)) {
            ConfigurableEnvironment environment = (ConfigurableEnvironment)ApplicationContextHolder.getBean(ConfigurableEnvironment.class);
            InetUtils inetUtils = (InetUtils)ApplicationContextHolder.getBean(InetUtils.class);
            if (environment != null && inetUtils != null) {
                String identify = IdentifyUtil.generate(environment, inetUtils);
                return identify;
            }
            Thread.sleep(500L);
        }
        return IDENTIFY;
    }

    public static String getThreadPoolIdentify(String threadPoolId, String itemId, String namespace) {
        ArrayList params = Lists.newArrayList((Object[])new String[]{threadPoolId, itemId, namespace, IdentifyUtil.getIdentify()});
        return Joiner.on((String)"+").join((Iterable)params);
    }

    static {
        CLIENT_IDENTIFICATION_VALUE = IdUtil.simpleUUID();
    }
}

