
--
CREATE TABLE IF NOT EXISTS USERS (
  username VARCHAR_IGNORECASE(50)  NOT NULL PRIMARY KEY,
  password VARCHAR_IGNORECASE(500) NOT NULL,
  enabled  BOOLEAN                 NOT NULL
);

--
CREATE TABLE IF NOT EXISTS AUTHORITIES (
  username  VARCHAR_IGNORECASE(50) NOT NULL,
  authority VARCHAR_IGNORECASE(50) NOT NULL,
  CONSTRAINT fk_authorities_users FOREIGN KEY (username) REFERENCES USERS (username)
);

CREATE UNIQUE INDEX IF NOT EXISTS ix_auth_username ON AUTHORITIES (username, authority);

--
CREATE TABLE IF NOT EXISTS GROUPS (
  id BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 0) PRIMARY KEY,
  group_name VARCHAR_IGNORECASE(50) NOT NULL
);

--
CREATE TABLE IF NOT EXISTS GROUP_AUTHORITIES (
  group_id BIGINT NOT NULL,
  authority VARCHAR(50) NOT NULL,
  CONSTRAINT fk_group_authorities_group FOREIGN KEY(group_id) REFERENCES GROUPS(id)
);

--
CREATE TABLE IF NOT EXISTS GROUP_MEMBERS (
  id BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 0) PRIMARY KEY,
  username VARCHAR(50) NOT NULL,
  group_id BIGINT NOT NULL,
  CONSTRAINT fk_group_members_group FOREIGN KEY(group_id) REFERENCES GROUPS(id)
);
