/*
 * Decompiled with CFR 0.152.
 */
package cn.home1.environment;

import cn.home1.oss.lib.common.crypto.AesCbcKey;
import cn.home1.oss.lib.common.crypto.AesKeyGenerator;
import cn.home1.oss.lib.common.crypto.JwtKeyGenerator;
import cn.home1.oss.lib.common.crypto.RsaKeys;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.builder.SpringApplicationBuilder;

public class Keygen
implements CommandLineRunner {
    public static void main(String ... args) {
        new SpringApplicationBuilder(new Object[0]).sources(new Class[]{Keygen.class}).bannerMode(Banner.Mode.OFF).run(args);
    }

    public void run(String ... args) throws Exception {
        if (args.length == 0) {
            System.err.println(this.usage());
        } else {
            String option = args[0];
            String result = this.generateKey(option);
            if (result != null) {
                System.out.print(result);
            } else {
                System.err.println(this.usage());
            }
        }
    }

    public String generateKey(String option) {
        String result;
        switch (option) {
            case "-aes": {
                String spec = AesCbcKey.keySpec((int)256);
                result = new AesKeyGenerator(spec).generateKey().toString();
                break;
            }
            case "-jwt": {
                String spec = "HS512";
                result = new JwtKeyGenerator(spec).generateKey().toString();
                break;
            }
            case "-rsa": {
                int keySize = 1024;
                result = RsaKeys.generateRsaKey(1024);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private String usage() {
        return "Usage: java -jar oss-lib-common-*.jar [OPTION]\n\t-aes\n\t\tgenerate random AES CBC key\n\t-jwt\n\t\tgenerate random JWT HS512 key\n\t-rsa\n\t\tgenerate random RSA1024 key\n";
    }
}

