/*
 * Decompiled with CFR 0.152.
 */
package cn.home1.oss.lib.common.crypto;

import cn.home1.oss.lib.common.CodecUtils;
import cn.home1.oss.lib.common.crypto.KeyExpression;
import cn.home1.oss.lib.common.crypto.RsaKey;
import cn.home1.oss.lib.common.crypto.RsaKeyGenerator;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

public abstract class RsaKeys {
    public static String generateRsaKey(int keySize) {
        String spec = RsaKey.keySpec((String)"PKCS8_X509", (int)keySize, (String)"PAIR");
        RsaKeyGenerator rsaKeyGenerator = new RsaKeyGenerator(spec);
        KeyExpression pairPkcs8X509 = rsaKeyGenerator.generateKey();
        KeyExpression pairPkcs1 = RsaKeyGenerator.convertPairFromPkcs8X509ToPkcs1((KeyExpression)pairPkcs8X509);
        StringBuilder result = new StringBuilder();
        System.err.println("privateKey PKCS8: " + RsaKeys.writePemFile(pairPkcs8X509, "PKCS8", "PRIV"));
        String privateKeyPkcs1PemFile = RsaKeys.writePemFile(pairPkcs1, "PKCS1", "PRIV");
        System.err.println("privateKey PKCS1: " + privateKeyPkcs1PemFile);
        System.err.println("Check with command line OpenSSL that the key format is as expected:");
        System.err.println("openssl rsa -in " + privateKeyPkcs1PemFile + " -noout -text");
        System.err.println("publicKey  x509: " + RsaKeys.writePemFile(pairPkcs8X509, "X509", "PUB"));
        System.err.println("publicKey PKCS1: " + RsaKeys.writePemFile(pairPkcs1, "PKCS1", "PUB"));
        return result.append(pairPkcs8X509.toString()).append("\n").append(pairPkcs1.toString()).append("\n").append(RsaKey.keySpec((String)"PRIV", (int)keySize, (String)"PKCS1")).append(':').append(RsaKey.extractPrivateKey((KeyExpression)pairPkcs1)).append("\n").append(RsaKey.keySpec((String)"PRIV", (int)keySize, (String)"PKCS8")).append(':').append(RsaKey.extractPrivateKey((KeyExpression)pairPkcs8X509)).append("\n").append(RsaKey.keySpec((String)"PUB", (int)keySize, (String)"PKCS1")).append(':').append(RsaKey.extractPublicKey((KeyExpression)pairPkcs1)).append("\n").append(RsaKey.keySpec((String)"PUB", (int)keySize, (String)"X509")).append(':').append(RsaKey.extractPublicKey((KeyExpression)pairPkcs8X509)).toString();
    }

    public static File keyFile(String keyFormat, int keySize, String keyType) {
        String targetDirectory = System.getProperty("user.dir", "/tmp");
        return new File(targetDirectory + "/" + RsaKey.keySpec((String)keyType, (int)keySize, (String)keyFormat) + ".pem");
    }

    public static String writePemFile(KeyExpression pair, String keyFormat, String keyType) {
        int keySize = RsaKey.keySize((String)pair.getSpec());
        File pemFile = RsaKeys.keyFile(keyFormat, keySize, keyType);
        byte[] bytes = CodecUtils.decodeBase64((String)("PRIV".equals(keyType) ? RsaKey.extractPrivateKey((KeyExpression)pair) : RsaKey.extractPublicKey((KeyExpression)pair)));
        FileUtils.writeStringToFile((File)pemFile, (String)RsaKeyGenerator.pem((byte[])bytes, (String)keyFormat, (String)keyType), (Charset)StandardCharsets.US_ASCII);
        return pemFile.getPath();
    }

    private RsaKeys() {
    }
}

