package cn.huermao.framework.annotation;

import cn.huermao.framework.constant.Constants;
import cn.huermao.framework.enums.LimitType;

import java.lang.annotation.*;

/**
 * 限流注解
 *
 * @author ruoyi
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RateLimit {
    /**
     * 限流key
     */
    String key() default Constants.RATE_LIMIT_KEY;

    /**
     * 限流时间,单位秒
     */
    int time() default 60;

    /**
     * 限流次数
     */
    int count() default 100;

    /**
     * 提示信息
     */
    String message() default "访问过于频繁，请稍后再试";

    /**
     * 限流类型
     */
    LimitType limitType() default LimitType.DEFAULT;
}
