package cn.huermao.framework.aspectJ;

import cn.huermao.framework.annotation.RateLimit;
import cn.huermao.framework.enums.LimitType;
import cn.huermao.framework.exception.ServiceException;
import cn.huermao.framework.utils.ServletUtils;
import cn.huermao.framework.utils.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

/**
 * 限流处理
 *
 * @author Lion Li
 */
@Aspect
@Component
public class RateLimitAspect {
//    private static final Logger log = LoggerFactory.getLogger(RateLimitAspect.class);
//    @Autowired
//    private RedisTemplate<String, Object> redisTemplate;
//
//    @Autowired
//    private RedisScript<Long> limitScript;
//
//    @Before("@annotation(rateLimit)")
//    public void doBefore(JoinPoint point, RateLimit rateLimit) throws Throwable {
//        String key = rateLimit.key();
//        int time = rateLimit.time();
//        int count = rateLimit.count();
//
//        String combineKey = getCombineKey(rateLimit, point);
//        List<Object> keys = Collections.singletonList(combineKey);
//        try {
//            // 调用lua脚本，传入三个参数
//            Long number = redisTemplate.execute(limitScript, keys, count, time);
//            if (StringUtils.isNull(number) || number.intValue() > count) {
//                throw new ServiceException(rateLimit.message());
//            }
//            log.info("限制请求'{}',当前请求'{}',缓存key'{}'", count, number.intValue(), key);
//        } catch (ServiceException e) {
//            throw e;
//        } catch (Exception e) {
//            throw new RuntimeException("服务器限流异常，请稍候再试");
//        }
//    }
//
//    public String getCombineKey(RateLimit rateLimit, JoinPoint point) {
//        // 获取注解中的key值
//        StringBuffer stringBuffer = new StringBuffer(rateLimit.key());
//        // 判断限流类型，如果是IP限流，就在key后添加上IP（若依自己写了一个获取ip的方法类，大家可以自行查看）
//        if (rateLimit.limitType() == LimitType.IP) {
//            stringBuffer.append(ServletUtils.getClientIP(ServletUtils.getRequest())).append("-");
//        }
//
//        // 获取方法
//        MethodSignature signature = (MethodSignature) point.getSignature();
//        Method method = signature.getMethod();
//        // 获取类
//        Class<?> targetClass = method.getDeclaringClass();
//        // key中添加方法名-类名
//        stringBuffer.append(targetClass.getName()).
//                append("-").
//                append(method.getName());
//        return stringBuffer.toString();
//    }
}
