package cn.huermao.framework.base;

import cn.huermao.framework.enums.Device;
import cn.huermao.framework.enums.Terminal;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 胡二毛
 */
public class BaseContextHandler {

    private BaseContextHandler() {
        throw new IllegalStateException("Utility class");
    }

    private static final ThreadLocal<Map<String, Object>> THREAD_LOCAL = ThreadLocal.withInitial(HashMap::new);

    public static void set(String key, Object value) {
        Map<String, Object> map = THREAD_LOCAL.get();
        map.put(key, value);
    }

    public static Object get(String key) {
        Map<String, Object> map = THREAD_LOCAL.get();
        return map.get(key);
    }

    public static Long getUid() {
        Object value = get("UID");
        return returnLongValue(value);
    }

    public static void setUid(Long uid) {
        set("UID", uid);
    }

    public static void setUsername(String username) {
        set("USERNAME", username);
    }

    public static String getUsername() {
        Object value = get("USERNAME");
        return returnObjectValue(value);
    }

    public static void setOpenid(String openid) {
        set("OPENID", openid);
    }

    public static String getOpenid() {
        Object value = get("OPENID");
        return returnObjectValue(value);
    }

    public static void setUnionId(String unionId) {
        set("UNION_ID", unionId);
    }

    public static String getUnionId() {
        Object value = get("UNION_ID");
        return returnObjectValue(value);
    }

    public static void setOrganizationId(Integer organizationId) {
        set("ORGANIZATION_ID", organizationId);
    }

    public static Integer getOrganizationId() {
        Object value = get("ORGANIZATION_ID");
        return returnIntegerValue(value);
    }

    public static void setTerminal(Terminal terminal) {
        set("TERMINAL", terminal);
    }

    public static Terminal getTerminal() {
        return (Terminal) get("TERMINAL");
    }

    public static void setDevice(Device device) {
        set("DEVICE", device);
    }

    public static Device getDevice() {
        return (Device) get("DEVICE");
    }

    public static void setPlatform(String platform) {
        set("PLATFORM", platform);
    }

    public static String getPlatform() {
        Object value = get("PLATFORM");
        return returnObjectValue(value);
    }

    public static void setVersion(String version) {
        set("VERSION", version);
    }

    public static String getVersion() {
        Object value = get("VERSION");
        return returnObjectValue(value);
    }

    private static String returnObjectValue(Object value) {
        return value == null ? null : value.toString();
    }

    private static Long returnLongValue(Object value) {
        return value == null ? null : Long.valueOf(value.toString());
    }

    private static Integer returnIntegerValue(Object value) {
        return value == null ? null : Integer.valueOf(value.toString());
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }
}
