package cn.huermao.framework.base;

import cn.huermao.framework.annotation.Log;
import cn.huermao.framework.annotation.RepeatSubmit;
import cn.huermao.framework.enums.BusinessType;
import cn.huermao.framework.validate.group.AddGroup;
import cn.huermao.framework.validate.group.EditGroup;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @param <Service>  业务层
 * @param <EntityBo> 新增或编辑的实体类
 * @author 胡二毛
 */
public class BaseCtrl<Service extends BaseService<EntityBo>, EntityBo> {

    @Autowired
    protected Service service;

    @ApiOperation(value = "保存", httpMethod = "POST")
    @Log(title = "【保存】", businessType = BusinessType.SAVE)
    @RepeatSubmit(message = "请勿重复提交")
    @PostMapping("save")
    public Result<?> save(@RequestBody @Validated(AddGroup.class) EntityBo bo) {
        return service.save(bo);
    }

    @ApiOperation(value = "新增", httpMethod = "POST")
    @Log(title = "【新增】", businessType = BusinessType.INSERT)
    @RepeatSubmit(message = "请勿重复提交")
    @PostMapping("add")
    public Result<?> add(@RequestBody @Validated(AddGroup.class) EntityBo bo) {
        return service.add(bo);
    }

    @ApiImplicitParam(name = "id", value = "要获取详情数据的指定ID", paramType = "path", required = true)
    @ApiOperation(value = "根据ID获取详情", httpMethod = "GET")
    @GetMapping("detail/{id}")
    public Result<?> detail(@PathVariable("id") Long id) {
        return service.detail(id);
    }

    @ApiOperation(value = "根据ID获取基础数据", httpMethod = "GET", notes = "一般用于编辑数据时，获取旧数据")
    @ApiImplicitParam(name = "id", value = "获取基础数据的指定ID", paramType = "path", required = true)
    @GetMapping("get/{id}")
    public Result<?> get(@PathVariable("id") Long id) {
        return service.get(id);
    }

    @ApiOperation(value = "更新", httpMethod = "PUT")
    @Log(title = "【更新】", businessType = BusinessType.UPDATE)
    @RepeatSubmit(message = "请勿重复提交")
    @PutMapping("update")
    public Result<?> update(@RequestBody @Validated(EditGroup.class) EntityBo bo) {
        return service.update(bo);
    }

    @ApiOperation(value = "根据ID删除", httpMethod = "DELETE")
    @ApiImplicitParam(name = "id", value = "要删除的数据指定ID", paramType = "path", required = true)
    @Log(title = "【删除】", businessType = BusinessType.DELETE)
    @RepeatSubmit
    @DeleteMapping("delete/{id}")
    public Result<?> delete(@PathVariable("id") Long id) {
        return service.delete(id);
    }

    @ApiOperation(value = "获取所有数据", httpMethod = "GET", notes = "一般用于下拉框、多选框等表单处")
    @GetMapping("all")
    public Result<?> all() {
        return service.all();
    }
}
