package cn.huermao.framework.base;

import cn.huermao.framework.validate.group.QueryGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * @author 胡二毛
 */
@ApiModel(value = "分页查询请求体")
@Data
public class BasePageQuery {
    /**
     * 页码
     */
    @ApiModelProperty(value = "页码", notes = "不能小于1")
    @NotNull(message = "请设置页码", groups = QueryGroup.class)
    @Min(value = 1, message = "页码不能小于'1'", groups = QueryGroup.class)
    private Integer pageNum;
    /**
     * 页尺寸
     */
    @ApiModelProperty(value = "页尺寸", notes = "不能小于1")
    @NotNull(message = "请设置页尺寸", groups = QueryGroup.class)
    @Min(value = 1, message = "页尺寸不能小于'1'", groups = QueryGroup.class)
    private Integer pageSize;
    /**
     * 排序的字段
     */
    @ApiModelProperty(value = "指定排序的字段")
    private String prop;
    /**
     * 排序方式 【true/null：desc；false：asc】
     */
    @ApiModelProperty(value = "指定排序的方式【true/null：desc；false：asc】")
    private Boolean order;
    /**
     * 指定数据ID
     */
    @ApiModelProperty(value = "指定数据ID")
    private Long id;
    /**
     * 用户ID
     */
    @ApiModelProperty(value = "指定用户ID")
    private Long uid;
    /**
     * 关键词
     */
    @ApiModelProperty(value = "关键词")
    private String keyword;
    /**
     * 开始时间
     */
    @ApiModelProperty(value = "开始时间", notes = "yyyy-MM-dd HH:mm:ss", example = "1993-05-20 14:22:22")
    private LocalDateTime startTime;
    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间", notes = "yyyy-MM-dd HH:mm:ss", example = "1993-05-20 14:22:22")
    private LocalDateTime endTime;
}
