package cn.huermao.framework.base;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author 胡二毛
 */
@ApiModel(value = "分页查询返回体")
@Data
public class BasePageResult<T> {
    /**
     * 总数据条数
     */
    @ApiModelProperty(value = "总数据条数", name = "total")
    private long total;
    /**
     * 当前页码
     */
    @ApiModelProperty(value = "当前页码", name = "pageNum")
    private int pageNum;
    /**
     * 当前数据列表
     */
    @ApiModelProperty(value = "当前数据列表", name = "list")
    private List<T> list;

    public BasePageResult<T> bind(PageInfo<T> pageInfo) {
        this.total = pageInfo.getTotal();
        this.pageNum = pageInfo.getPageNum();
        this.list = pageInfo.getList();
        return this;
    }

    public static <T> BasePageResult<T> generate(PageInfo<T> pageInfo) {
        BasePageResult<T> result = new BasePageResult<>();
        result.total = pageInfo.getTotal();
        result.pageNum = pageInfo.getPageNum();
        result.list = pageInfo.getList();
        return result;
    }
}
