package cn.huermao.framework.base;

import cn.huermao.framework.utils.ServletUtils;
import org.apache.http.HttpStatus;

/**
 * @param <EntityBo> 用于新增或更新的实体类
 * @author 胡二毛
 */
public interface BaseService<EntityBo> {
    /**
     * 保存接口
     *
     * @param bo 保存数据
     * @return 保存结果
     */
    default Result<?> save(EntityBo bo) {
        ServletUtils.getResponse().setStatus(HttpStatus.SC_NOT_FOUND);
        return Result.REQUEST_INVALID;
    }

    /**
     * 新增接口
     *
     * @param bo 新增数据
     * @return 新增结果
     */
    default Result<?> add(EntityBo bo) {
        ServletUtils.getResponse().setStatus(HttpStatus.SC_NOT_FOUND);
        return Result.REQUEST_INVALID;
    }

    /**
     * 根据ID获取详细数据，一般用于详情页附带其他信息
     *
     * @param id 相关ID
     * @return 详细数据
     */
    default Result<?> detail(Long id) {
        ServletUtils.getResponse().setStatus(HttpStatus.SC_NOT_FOUND);
        return Result.REQUEST_INVALID;
    }

    /**
     * 根据ID获取基本数据，一般用于修改页，或者基本信息
     *
     * @param id 相关ID
     * @return 基本数据
     */
    default Result<?> get(Long id) {
        ServletUtils.getResponse().setStatus(HttpStatus.SC_NOT_FOUND);
        return Result.REQUEST_INVALID;
    }

    /**
     * 更新接口
     *
     * @param bo 更新数据
     * @return 更新结果
     */
    default Result<?> update(EntityBo bo) {
        ServletUtils.getResponse().setStatus(HttpStatus.SC_NOT_FOUND);
        return Result.REQUEST_INVALID;
    }

    /**
     * 删除接口
     *
     * @param id 相关ID
     * @return 删除结果
     */
    default Result<?> delete(Long id) {
        ServletUtils.getResponse().setStatus(HttpStatus.SC_NOT_FOUND);
        return Result.REQUEST_INVALID;
    }

    /**
     * 获取相关所有数据，一般用于数据量少，无需分页时调用，如类型枚举类
     *
     * @return 所有数据
     */
    default Result<?> all() {
        ServletUtils.getResponse().setStatus(HttpStatus.SC_NOT_FOUND);
        return Result.REQUEST_INVALID;
    }
}
