package cn.huermao.framework.config;

import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

/**
 * 程序注解配置
 *
 * @author Lion Li
 */
//表示通过aop框架暴露该代理对象,AopContext能够访问。用于内部调用同样被aop拦截
//在Spring中，如果不在配置类中添加@EnableAspectJAutoProxy，那么所有切面注解是不生效的
// （springboot因为有自动配置，所以不需要开发人员手工配置@EnableAspectJAutoProxy）
@EnableAspectJAutoProxy(exposeProxy = true)
@Configuration
public class ApplicationConfig {

}
