package cn.huermao.framework.config.wx;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.huermao.framework.properties.WeChatProperties;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author 胡二毛
 */
@Slf4j
@Configuration
public class WxChatConfig {
    private final WeChatProperties weChatProperties;

    @Autowired
    public WxChatConfig(WeChatProperties weChatProperties) {
        this.weChatProperties = weChatProperties;
    }

    @Bean("wxMaService")
    @ConditionalOnProperty(prefix = "we-chat.mini-app", name = "enable", havingValue = "true")
    public WxMaService getWxMaService() {
        WeChatProperties.MiniApp miniApp = weChatProperties.getMiniApp();
        WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
        config.setAppid(miniApp.getAppId());
        config.setSecret(miniApp.getSecret());
        config.setMsgDataFormat("JSON");
        WxMaService wxMaService = new WxMaServiceImpl();
        wxMaService.setWxMaConfig(config);
        log.info("初始化 【微信小程序】 配置");
        return wxMaService;
    }

    @Bean("wxPayService")
    @ConditionalOnProperty(prefix = "we-chat.pay", name = "enable", havingValue = "true")
    public WxPayService getWxPayService() {
        WeChatProperties.Pay pay = weChatProperties.getPay();
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(pay.getAppId());
        payConfig.setMchId(pay.getMchId());
        payConfig.setMchKey(pay.getMchKey());
        payConfig.setNotifyUrl(pay.getNotifyUrl());
        payConfig.setKeyPath(pay.getKeyPath());
        payConfig.setApiV3Key(pay.getApiV3Key());
        payConfig.setPrivateKeyPath(pay.getPrivateKeyPath());
        payConfig.setPrivateCertPath(pay.getPrivateCertPath());
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        log.info("初始化 【微信支付】 配置");
        return wxPayService;
    }
}
