package cn.huermao.framework.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;

/**
 * 操作日志记录表 oper_log
 *
 * @author ruoyi
 */

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class LogInfo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 操作模块
     */
    private String title;

    /**
     * 业务类型
     */
    private Byte businessType;

    /**
     * 业务类型数组
     */
    private Integer[] businessTypes;

    /**
     * 请求方法
     */
    private String method;

    /**
     * 请求方式
     */
    private String requestMethod;

    /**
     * 用户终端
     */
    private String terminal;

    /**
     * 版本号
     */
    private String version;

    /**
     * 业务平台
     */
    private String platform;

    /**
     * 操作人员
     */
    private Long userId;

    /**
     * 部门名称
     */
    private String deptName;

    /**
     * 请求url
     */
    private String operUrl;

    /**
     * 操作地址
     */
    private String operIp;

    /**
     * 操作地点
     */
    private String operLocation;

    /**
     * 请求参数
     */
    private String operParam;

    /**
     * 返回参数
     */
    private String jsonResult;

    /**
     * 操作状态（0正常 1异常）
     */
    private byte status;

    /**
     * 错误消息
     */
    private String errorMsg;

    /**
     * 操作时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime operTime;

    @Override
    public String toString() {
        return "LogInfo:{" +
                "title:\"" + title + '\"' +
                ", businessType:" + businessType +
                ", businessTypes:" + Arrays.toString(businessTypes) +
                ", method:\"" + method + '\"' +
                ", requestMethod:\"" + requestMethod + '\"' +
                ", terminal:\"" + terminal + '\"' +
                ", version:\"" + version + '\"' +
                ", platform:\"" + platform + '\"' +
                ", userId:" + userId +
                ", deptName:\"" + deptName + '\"' +
                ", operUrl:\"" + operUrl + '\"' +
                ", operIp:\"" + operIp + '\"' +
                ", operLocation:\"" + operLocation + '\"' +
                ", operParam:" + operParam +
                ", jsonResult:" + jsonResult +
                ", status:" + status +
                ", errorMsg:\"" + errorMsg + '\"' +
                ", operTime:" + operTime +
                '}';
    }
}
