package cn.huermao.framework.enums;

public enum ResultCode {
    //此code让前端重新获取token
    INVALID_TOKEN(1000, false, "无效的TOKEN"),
    //无需强制登录，只需在页面提示并提供跳转登陆/注册的按钮
    NOT_LOGGED_IN(1001, false, "请先登陆或注册"),
    //需强制登陆
    PLEASE_LOGGED_IN(1002, false, "请先登陆或注册"),
    //直接重定向
    REDIRECT(1003, false, "重定向"),
    NO_PERMISSION(1004, false, "您无权限"),
    REQUEST_INVALID(1005, false, "无效的请求"),

    //此类在2000-2999之间，表示操作成功
    SUCCESS(2000, true, "操作成功"),
    SUCCESS_TOAST(2001, true, "操作成功"),
    SUCCESS_POPUP(2002, true, "操作成功"),
    SUCCESS_TOAST_REDIRECT(2003, true, "重定向"),

    //此类在3000-3999之间，表示操作失败
    FAIL(3000, false, "操作失败"),
    FAIL_TOAST(3001, false, "操作失败"),
    FAIL_POPUP(3002, false, "操作失败"),
    FAIL_TOAST_REDIRECT(3003, false, "重定向");

    ResultCode(int code, boolean status, String msg) {
        this.code = code;
        this.status = status;
        this.msg = msg;
    }

    private int code;
    private boolean status;
    private String msg;

    public int getCode() {
        return code;
    }

    public void setCode(short code) {
        this.code = code;
    }

    public boolean getStatus() {
        return status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
