package cn.huermao.framework.filter;

import cn.huermao.framework.base.BaseContextHandler;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import java.io.IOException;

@Component
@Order(Integer.MIN_VALUE)
@WebFilter(urlPatterns = "/*", filterName = "FRAMEWORK_FILTER")
public class FrameworkFilter implements Filter {
    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        BaseContextHandler.remove();
        filterChain.doFilter(servletRequest, servletResponse);
        BaseContextHandler.remove();
    }

    @Override
    public void destroy() {
    }
}
