package cn.huermao.framework.interceptor;

import cn.huermao.framework.base.BaseContextHandler;
import cn.huermao.framework.base.Result;
import cn.huermao.framework.enums.ResultCode;
import cn.huermao.framework.utils.ServletUtils;
import cn.hutool.json.JSONUtil;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 有一些接口，不需要强制注册或登陆，但是也可以访问，这种情况下肯定是没有数据的
 * 前端只需展示【请先登陆】或【暂无数据】之类的提示
 * 所以没有进入方法的必要，更不用查询数据库，直接返回【Result.success()】即可
 * <p>
 * ----- 前端注意赋默认值 -----
 *
 * @author 胡二毛
 */
@Configuration
public class NoLoginRequiredInterceptor implements HandlerInterceptor {
    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {

    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView mv) {

    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Long uid = BaseContextHandler.getUid();
        if (uid == null) {
            ServletUtils.renderString(response, JSONUtil.toJsonStr(new Result<Void>(ResultCode.NOT_LOGGED_IN.getCode(), ResultCode.NOT_LOGGED_IN.getMsg())));
            return false;
        }
        return true;
    }
}