package cn.huermao.framework.manager;

import cn.huermao.framework.config.ali.ALiOssConfig;
import cn.huermao.framework.utils.Threads;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.PreDestroy;

/**
 * 确保应用退出时能关闭后台线程
 *
 * @author Lion Li
 */
@Slf4j
@Component
public class ShutdownManager {

    @PreDestroy
    public void destroy() {
        shutdownAsyncManager();
    }

    /**
     * 停止异步执行任务
     */
    private void shutdownAsyncManager() {
        try {
            Threads.shutdownAndAwaitTermination(ALiOssConfig.DELETE_OSS_POOL);
            log.info("====关闭阿里云线程池====");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}
