package cn.huermao.framework.properties;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author 胡二毛
 */
@Data
@Component
@ConfigurationProperties(prefix = "ali")
public class ALiProperties {
    private final ALiProperties.Oss oss;

    @Autowired
    public ALiProperties() {
        this.oss = new ALiProperties.Oss();
    }

    public Oss getOss() {
        return oss;
    }

    @Getter
    @Setter
    public static class Oss {
        private Boolean enable = false;
        private String endpoint;
        private String bucketUrl;
        private String accessKeySecret;
        private String accessKeyId;
        private String bucketName;
        /**
         * 文件长度（MB）
         */
        private int maxLength = 100;
        /**
         * 密钥超时时长（毫秒）
         */
        private long timeout = 300000;
    }
}
