package cn.huermao.framework.properties;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import springfox.documentation.service.VendorExtension;

import java.util.List;

/**
 * @author 胡二毛
 */
@Data
@Component
@ConfigurationProperties(prefix = "swagger")
public class SwaggerProperties {
    /**
     * 是否启动
     */
    private Boolean enable = false;
    /**
     * 设置请求的统一前缀
     */
    private String pathMapping;
    /**
     * 标题
     */
    private String title;
    /**
     * 描述
     */
    private String description;
    /**
     * 服务条款网址
     */
    private String termsOfServiceUrl;
    /**
     * 许可
     */
    private String license;
    /**
     * 许可链接
     */
    private String licenseUrl;
    /**
     * 版本
     */
    private String version;
    /**
     * 作者
     */
    private String author = "胡二毛";
    /**
     * 作者网站
     */
    private String url;
    /**
     * 作者邮箱
     */
    private String email;
    /**
     * 扩展信息
     */
    private final List<Extension> extensions;
    /**
     * 组配置
     */
    private List<Groups> groups;

    @Setter
    @NoArgsConstructor
    public static class Extension implements VendorExtension {
        private String name;
        private String value;

        @Override
        public String getName() {
            return name;
        }

        @Override
        public Object getValue() {
            return value;
        }
    }

    @Data
    @NoArgsConstructor
    public static class Groups {

        /**
         * 组名
         */
        private String name;

        /**
         * 基础包路径
         */
        private String basePackage;

    }
}
