package cn.huermao.framework.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * token 配置属性
 *
 * @author Lion Li
 */
@Data
@Component
@ConfigurationProperties(prefix = "token")
public class TokenProperties {
    /**
     * 令牌自定义标识
     */
    private String header;
    /**
     * 令牌秘钥
     */
    private String secret;
    /**
     * 令牌有效时长（单位：毫秒，默认1天）
     */
    private long expireTime = 86400000;
    /**
     * 刷新令牌标志
     */
    private String refreshHeader;
    /**
     * 刷新令牌秘钥
     */
    private String refreshSecret;
    /**
     * 刷新令牌有效期（单位：毫秒，默认7天）
     */
    private long refreshExpireTime = 7;
}
